/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;

public class PDF3DExData3DM
extends PDFExData {
    public static final ASName k_M3DREF = ASName.create("M3DREF");

    private PDF3DExData3DM(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DExData3DM newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DExData3DM pdfObject = new PDF3DExData3DM(cosObject);
        pdfObject.setSubtype();
        return pdfObject;
    }

    public static PDF3DExData3DM newInstance(PDFDocument pdfDocument, PDF3DMeasurement measurement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDF3DExData3DM pdfObject = PDF3DExData3DM.newInstance(pdfDocument);
        pdfObject.setM3DREF(measurement);
        return pdfObject;
    }

    public static PDF3DExData3DM getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DExData3DM pdfObject = (PDF3DExData3DM)PDFCosObject.getCachedInstance(cosObject, PDF3DExData3DM.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DExData3DM(cosObject);
        }
        return pdfObject;
    }

    private void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Subtype, PDFExData.k_3DM);
    }

    public PDF3DMeasurement getM3DREF() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DMeasurement.getInstance(this.getDictionaryCosObjectValue(k_M3DREF));
    }

    public void setM3DREF(PDF3DMeasurement value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("M3DREF is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(k_M3DREF, value);
    }

    public boolean hasM3DREF() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_M3DREF);
    }
}

