/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDStream;

public class PDF3DDDict
extends PDFCosDictionary {
    private PDF3DDDict(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DDDict newInstance(PDFDocument pdfDocument, PDF3DDStream key_3DD) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_3DD == null) {
            throw new PDFInvalidParameterException("3DD is required when creating newInstance of PDF3DDDict.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DDDict pdfObject = new PDF3DDDict(cosObject);
        pdfObject.set3DD(key_3DD);
        return pdfObject;
    }

    public static PDF3DDDict getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DDDict pdfObject = (PDF3DDDict)PDFCosObject.getCachedInstance(cosObject, PDF3DDDict.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DDDict(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_3DRef)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDF3DDStream get3DD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DDStream.getInstance(this.getDictionaryCosObjectValue(ASName.k_3DD));
    }

    public void set3DD(PDF3DDStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("3DD is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_3DD, value);
    }

    public boolean has3DD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DD);
    }
}

