/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleType;

public class PDFStructureRole {
    public static final ASName k_Document = ASName.create("Document");
    public static final ASName k_Part = ASName.create("Part");
    public static final ASName k_Art = ASName.create("Art");
    public static final ASName k_Sect = ASName.create("Sect");
    public static final ASName k_Div = ASName.create("Div");
    public static final ASName k_BlockQuote = ASName.create("BlockQuote");
    public static final ASName k_Caption = ASName.create("Caption");
    public static final ASName k_TOC = ASName.create("TOC");
    public static final ASName k_TOCI = ASName.create("TOCI");
    public static final ASName k_Index = ASName.create("Index");
    public static final ASName k_NonStruct = ASName.create("NonStruct");
    public static final ASName k_Private = ASName.create("Private");
    public static final ASName k_P = ASName.create("P");
    public static final ASName k_H1 = ASName.create("H1");
    public static final ASName k_H4 = ASName.create("H4");
    public static final ASName k_H = ASName.create("H");
    public static final ASName k_H2 = ASName.create("H2");
    public static final ASName k_H5 = ASName.create("H5");
    public static final ASName k_H3 = ASName.create("H3");
    public static final ASName k_H6 = ASName.create("H6");
    public static final ASName k_L = ASName.create("L");
    public static final ASName k_Lbl = ASName.create("Lbl");
    public static final ASName k_LI = ASName.create("LI");
    public static final ASName k_LBody = ASName.create("LBody");
    public static final ASName k_Table = ASName.create("Table");
    public static final ASName k_TR = ASName.create("TR");
    public static final ASName k_TH = ASName.create("TH");
    public static final ASName k_TD = ASName.create("TD");
    public static final ASName k_THead = ASName.create("THead");
    public static final ASName k_TBody = ASName.create("TBody");
    public static final ASName k_TFoot = ASName.create("TFoot");
    public static final ASName k_Span = ASName.create("Span");
    public static final ASName k_Quote = ASName.create("Quote");
    public static final ASName k_Note = ASName.create("Note");
    public static final ASName k_Reference = ASName.create("Reference");
    public static final ASName k_BibEntry = ASName.create("BibEntry");
    public static final ASName k_Code = ASName.create("Code");
    public static final ASName k_Link = ASName.create("Link");
    public static final ASName k_Annot = ASName.create("Annot");
    public static final ASName k_Ruby = ASName.create("Ruby");
    public static final ASName k_RB = ASName.create("RB");
    public static final ASName k_RT = ASName.create("RT");
    public static final ASName k_RP = ASName.create("RP");
    public static final ASName k_Warichu = ASName.create("Warichu");
    public static final ASName k_WT = ASName.create("WT");
    public static final ASName k_WP = ASName.create("WP");
    public static final ASName k_Figure = ASName.create("Figure");
    public static final ASName k_Formula = ASName.create("Formula");
    public static final ASName k_Form = ASName.create("Form");
    public static final PDFStructureRole Document = new PDFStructureRole(k_Document, PDFStructureRoleType.Group);
    public static final PDFStructureRole Part = new PDFStructureRole(k_Part, PDFStructureRoleType.Group);
    public static final PDFStructureRole Art = new PDFStructureRole(k_Art, PDFStructureRoleType.Group);
    public static final PDFStructureRole Sect = new PDFStructureRole(k_Sect, PDFStructureRoleType.Group);
    public static final PDFStructureRole Div = new PDFStructureRole(k_Div, PDFStructureRoleType.Group);
    public static final PDFStructureRole BlockQuote = new PDFStructureRole(k_BlockQuote, PDFStructureRoleType.Group);
    public static final PDFStructureRole Caption = new PDFStructureRole(k_Caption, PDFStructureRoleType.Group);
    public static final PDFStructureRole TOC = new PDFStructureRole(k_TOC, PDFStructureRoleType.Group);
    public static final PDFStructureRole TOCI = new PDFStructureRole(k_TOCI, PDFStructureRoleType.Group);
    public static final PDFStructureRole Index = new PDFStructureRole(k_Index, PDFStructureRoleType.Group);
    public static final PDFStructureRole NonStruct = new PDFStructureRole(k_NonStruct, PDFStructureRoleType.Group);
    public static final PDFStructureRole Private = new PDFStructureRole(k_Private, PDFStructureRoleType.Group);
    public static final PDFStructureRole P = new PDFStructureRole(k_P, PDFStructureRoleType.Block);
    public static final PDFStructureRole H1 = new PDFStructureRole(k_H1, PDFStructureRoleType.Block);
    public static final PDFStructureRole H4 = new PDFStructureRole(k_H4, PDFStructureRoleType.Block);
    public static final PDFStructureRole H = new PDFStructureRole(k_H, PDFStructureRoleType.Block);
    public static final PDFStructureRole H2 = new PDFStructureRole(k_H2, PDFStructureRoleType.Block);
    public static final PDFStructureRole H5 = new PDFStructureRole(k_H5, PDFStructureRoleType.Block);
    public static final PDFStructureRole H3 = new PDFStructureRole(k_H3, PDFStructureRoleType.Block);
    public static final PDFStructureRole H6 = new PDFStructureRole(k_H6, PDFStructureRoleType.Block);
    public static final PDFStructureRole L = new PDFStructureRole(k_L, PDFStructureRoleType.Block);
    public static final PDFStructureRole Lbl = new PDFStructureRole(k_Lbl, PDFStructureRoleType.Block);
    public static final PDFStructureRole LI = new PDFStructureRole(k_LI, PDFStructureRoleType.Block);
    public static final PDFStructureRole LBody = new PDFStructureRole(k_LBody, PDFStructureRoleType.Block);
    public static final PDFStructureRole Table = new PDFStructureRole(k_Table, PDFStructureRoleType.Table);
    public static final PDFStructureRole TR = new PDFStructureRole(k_TR, PDFStructureRoleType.Table);
    public static final PDFStructureRole TH = new PDFStructureRole(k_TH, PDFStructureRoleType.Table);
    public static final PDFStructureRole TD = new PDFStructureRole(k_TD, PDFStructureRoleType.Table);
    public static final PDFStructureRole THead = new PDFStructureRole(k_THead, PDFStructureRoleType.Table);
    public static final PDFStructureRole TBody = new PDFStructureRole(k_TBody, PDFStructureRoleType.Table);
    public static final PDFStructureRole TFoot = new PDFStructureRole(k_TFoot, PDFStructureRoleType.Table);
    public static final PDFStructureRole Span = new PDFStructureRole(k_Span, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Quote = new PDFStructureRole(k_Quote, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Note = new PDFStructureRole(k_Note, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Reference = new PDFStructureRole(k_Reference, PDFStructureRoleType.Inline);
    public static final PDFStructureRole BibEntry = new PDFStructureRole(k_BibEntry, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Code = new PDFStructureRole(k_Code, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Link = new PDFStructureRole(k_Link, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Annot = new PDFStructureRole(k_Annot, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Ruby = new PDFStructureRole(k_Ruby, PDFStructureRoleType.Inline);
    public static final PDFStructureRole RB = new PDFStructureRole(k_RB, PDFStructureRoleType.Inline);
    public static final PDFStructureRole RT = new PDFStructureRole(k_RT, PDFStructureRoleType.Inline);
    public static final PDFStructureRole RP = new PDFStructureRole(k_RP, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Warichu = new PDFStructureRole(k_Warichu, PDFStructureRoleType.Inline);
    public static final PDFStructureRole WT = new PDFStructureRole(k_WT, PDFStructureRoleType.Inline);
    public static final PDFStructureRole WP = new PDFStructureRole(k_WP, PDFStructureRoleType.Inline);
    public static final PDFStructureRole Figure = new PDFStructureRole(k_Figure, PDFStructureRoleType.Illustration);
    public static final PDFStructureRole Formula = new PDFStructureRole(k_Formula, PDFStructureRoleType.Illustration);
    public static final PDFStructureRole Form = new PDFStructureRole(k_Form, PDFStructureRoleType.Illustration);
    private static final PDFStructureRole[] allRoles = new PDFStructureRole[]{Document, Part, Art, Sect, Div, BlockQuote, Caption, TOC, TOCI, Index, NonStruct, Private, P, H1, H4, H, H2, H5, H3, H6, L, Lbl, LI, LBody, Table, TR, TH, TD, THead, TBody, TFoot, Span, Quote, Note, Reference, BibEntry, Code, Link, Annot, Ruby, RB, RT, RP, Warichu, WT, WP, Figure, Formula, Form};
    private final ASName mRole;
    private final PDFStructureRoleType mType;

    private PDFStructureRole(ASName role, PDFStructureRoleType type) {
        this.mRole = role;
        this.mType = type;
    }

    public ASName getName() {
        return this.mRole;
    }

    public static PDFStructureRole getRole(ASName name) {
        for (int ind = 0; ind < allRoles.length; ++ind) {
            if (!allRoles[ind].getName().equals(name)) continue;
            return allRoles[ind];
        }
        return null;
    }

    public boolean isEqual(PDFStructureRole role) {
        return this.getName().equals(role.getName());
    }

    public PDFStructureRoleType getType() {
        return this.mType;
    }
}

