/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentFactory;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleType;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import java.util.List;

public abstract class PDFStructureNode
extends PDFCosDictionary {
    protected PDFStructureNode(CosObject cosObj) throws PDFInvalidDocumentException {
        super(cosObj);
    }

    protected PDFStructureNode(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDoc));
    }

    public abstract PDFStructureType getStructureType();

    public void removeKids() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_K);
    }

    public PDFStructureContentInterface getContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureContentFactory.getInstance(this.getDictionaryValue(ASName.k_K));
    }

    public void addContent(PDFStructureContentInterface content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureContentInterface rootContent = this.getContent();
        CosObject dict = this.getCosObject();
        if (dict instanceof CosDictionary) {
            if (rootContent == null) {
                this.setDictionaryValue(ASName.k_K, content.getCosObject());
            } else {
                if (!rootContent.getStructureType().equals(PDFStructureType.Array)) {
                    rootContent = PDFStructureContentArray.newInstance(this.getPDFDocument(), rootContent);
                    this.setDictionaryValue(ASName.k_K, rootContent.getCosObject());
                }
                PDFStructureContentIterator contentIterator = content.contentIterator();
                while (contentIterator.hasNext()) {
                    ((PDFStructureContentArray)rootContent).add(contentIterator.next());
                }
            }
        }
    }

    public void addContent(int index, PDFStructureContentInterface content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureContentInterface rootContent = this.getContent();
        CosObject dict = this.getCosObject();
        if (dict instanceof CosDictionary) {
            if (rootContent == null) {
                this.setDictionaryValue(ASName.k_K, content.getCosObject());
            } else {
                if (!rootContent.getStructureType().equals(PDFStructureType.Array)) {
                    rootContent = PDFStructureContentArray.newInstance(this.getPDFDocument(), rootContent);
                    this.setDictionaryValue(ASName.k_K, rootContent.getCosObject());
                }
                PDFStructureContentIterator contentIterator = content.contentIterator();
                while (contentIterator.hasNext()) {
                    ((PDFStructureContentArray)rootContent).add(index, contentIterator.next());
                }
            }
        }
    }

    public int getContentIndex(PDFStructureContentInterface searchedElement, boolean searchLast) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        int idxSearchElement = -1;
        boolean found = false;
        int count = -1;
        int idxNonElementTypeBeforeSearched = -1;
        int idxNonElementTypeAfterSearched = -1;
        if (searchedElement == null) {
            return idxSearchElement;
        }
        PDFStructureContentInterface parentContent = this.getContent();
        CosObject dict = this.getCosObject();
        if (dict instanceof CosDictionary) {
            if (parentContent == null) {
                return idxSearchElement;
            }
            if (!parentContent.getStructureType().equals(PDFStructureType.Array)) {
                return 0;
            }
            PDFStructureContentIterator contentIterator = parentContent.contentIterator();
            while (contentIterator.hasNext()) {
                ++count;
                PDFStructureContentInterface curElem = contentIterator.next();
                if (curElem.getStructureType() != PDFStructureType.Element) {
                    idxNonElementTypeBeforeSearched = count;
                    if (found) {
                        idxNonElementTypeAfterSearched = count;
                    }
                }
                if (PDFUtil.isPDFCosObjectRefEqual(curElem.getPDFCosObject(), searchedElement.getPDFCosObject())) {
                    idxSearchElement = count;
                    found = true;
                    if (!searchLast) break;
                    idxNonElementTypeAfterSearched = -1;
                    continue;
                }
                if (curElem.getStructureType() != PDFStructureType.Element) continue;
                idxNonElementTypeBeforeSearched = -1;
                if (!found) continue;
                break;
            }
        }
        if (idxNonElementTypeBeforeSearched != -1 && !searchLast && idxNonElementTypeBeforeSearched < idxSearchElement) {
            idxSearchElement = idxNonElementTypeBeforeSearched;
        }
        if (idxNonElementTypeAfterSearched != -1 && searchLast && idxNonElementTypeAfterSearched > idxSearchElement) {
            idxSearchElement = idxNonElementTypeAfterSearched;
        }
        return idxSearchElement;
    }

    public PDFStructureElement getFirstElement(PDFStructureRoleType type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureRole role = null;
        PDFStructureElement structElement = null;
        if (this.getStructureType() == PDFStructureType.Element) {
            structElement = (PDFStructureElement)this;
            role = PDFStructureUtils.getRole(structElement);
        }
        if (role == null) {
            return null;
        }
        if (type.contains(role.getType())) {
            return structElement;
        }
        PDFStructureContentInterface kids = this.getContent();
        if (kids == null) {
            return null;
        }
        PDFStructureContentIterator kidsIter = kids.contentIterator();
        while (kidsIter.hasNext()) {
            PDFStructureElement nextElem;
            PDFStructureContentInterface nextNode = kidsIter.next();
            if (nextNode.getStructureType() != PDFStructureType.Element || (nextElem = ((PDFStructureElement)nextNode).getFirstElement(type)) == null) continue;
            return nextElem;
        }
        return null;
    }

    public PDFStructureElement getFirstElement(PDFStructureContentArray pageElemArray, List matchedElems) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getFirstOrLastElement(null, pageElemArray, matchedElems);
    }

    public PDFStructureElement getLastElement(PDFStructureRoleType type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureContentInterface kids = this.getContent();
        if (kids == null) {
            return null;
        }
        PDFStructureContentIterator kidsIter = kids.contentIterator();
        while (kidsIter.hasNext()) {
            PDFStructureContentInterface next = kidsIter.next();
            if (next.getStructureType() != PDFStructureType.Element) {
                return this.getStructureType() != PDFStructureType.Element ? null : (PDFStructureElement)this;
            }
            PDFStructureElement afterNext = ((PDFStructureElement)next).getLastElement(type);
            if (afterNext == null) continue;
            return afterNext;
        }
        return null;
    }

    public PDFStructureElement getLastElement(PDFPage page, PDFStructureContentArray pageElemArray, List matchedElems) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getFirstOrLastElement(page, pageElemArray, matchedElems);
    }

    public PDFStructureNode getNodeBefore(PDFStructureRole role) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getStructureType() == PDFStructureType.Root) {
            return this;
        }
        if (this.getStructureType() != PDFStructureType.Element) {
            return null;
        }
        PDFStructureNode parent = ((PDFStructureElement)this).getParent();
        if (parent.getStructureType() == PDFStructureType.Element && PDFStructureUtils.getRole((PDFStructureElement)parent) != role) {
            return parent;
        }
        return parent.getNodeBefore(role);
    }

    /*
     * Exception decompiling
     */
    private PDFStructureElement getFirstOrLastElement(PDFPage page, PDFStructureContentArray pageElemArray, List matchedElems) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[UNCONDITIONALDOLOOP]], but top level block is 3[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ASName getStructureNameType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }
}

