/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidStructureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureScalarIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFStructureMCID
extends PDFCosObject
implements PDFStructureContentInterface {
    private PDFStructureMCID(CosObject item) throws PDFInvalidStructureException, PDFInvalidDocumentException {
        super(item);
        if (item.getType() != 1) {
            throw new PDFInvalidStructureException("Expected a numeric object");
        }
    }

    @Override
    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public void addContent(PDFStructureContentInterface content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    @Override
    public PDFStructureContentIterator contentIterator() {
        return new PDFStructureScalarIterator(this);
    }

    public static PDFStructureContentInterface getInstance(CosObject cosObject) throws PDFInvalidStructureException, PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureMCID pdfObject = (PDFStructureMCID)PDFCosObject.getCachedInstance(cosObject, PDFStructureMCID.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureMCID(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureMCID newInstance(PDFDocument pdfDoc, int mcid) throws PDFInvalidStructureException, PDFInvalidDocumentException {
        CosNumeric newMCID = PDFCosObject.newCosNumeric(pdfDoc, mcid);
        return new PDFStructureMCID(newMCID);
    }

    public PDFStructureContentInterface getContent() {
        return null;
    }

    public Integer getMCID() {
        CosNumeric cosMCID = (CosNumeric)this.getCosObject();
        return cosMCID == null ? null : (Integer)cosMCID.getValue();
    }

    @Override
    public PDFStructureType getStructureType() {
        return PDFStructureType.MCID;
    }
}

