/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidStructureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentScalar;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFStructureElement
extends PDFStructureContentScalar {
    public static final ASName k_ActualText = ASName.create("ActualText");

    private PDFStructureElement(CosObject cosObj) throws PDFInvalidDocumentException {
        super(cosObj);
    }

    public static PDFStructureElement getInstance(CosObject cosObject) throws PDFInvalidStructureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return new PDFStructureElement(cosObject);
    }

    public static PDFStructureElement getInstance(CosDictionary cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureElement pdfObject = (PDFStructureElement)PDFCosObject.getCachedInstance(cosObject, PDFStructureElement.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureElement(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureElement newInstance(PDFDocument pdfDoc, ASName type, PDFStructureNode parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosElem = pdfDoc.getCosDocument().createCosDictionary();
        cosElem.put(ASName.k_S, type);
        if (parent != null) {
            cosElem.put(ASName.k_P, parent.getCosObject());
        }
        return new PDFStructureElement(cosElem);
    }

    public PDFStructureNode getParent() throws PDFInvalidStructureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary parent = (CosDictionary)((CosDictionary)this.getCosObject()).get(ASName.k_P);
        if (parent == null) {
            throw new PDFInvalidStructureException("Invalid Structure: Structure element does not have a parent");
        }
        ASName type = null;
        if (parent.containsKey(ASName.k_Type)) {
            type = parent.getName(ASName.k_Type);
        }
        if (type == null || type.equals(ASName.k_StructElem)) {
            return PDFStructureElement.getInstance(parent);
        }
        if (type.equals(ASName.k_StructTreeRoot)) {
            return PDFStructureRoot.getInstance(parent);
        }
        return null;
    }

    public String getActualText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_ActualText);
    }

    public void setActualText(String text) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_ActualText, text);
    }

    public void setActualText(String text, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_ActualText, text, unicode);
    }

    public PDFStructureElement delete() {
        return null;
    }

    @Override
    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPage.getInstance(((CosDictionary)this.getCosObject()).get(ASName.k_Pg));
    }

    public void setPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Pg, page);
    }

    public void addMCID(PDFStructureContentArray parentContent, int mcid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureMCID mcidChild = PDFStructureMCID.newInstance(this.getPDFDocument(), mcid);
        this.addContent(mcidChild);
        parentContent.add(mcid, this);
    }

    public ASString getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getCosObject();
        if (cosObject instanceof CosDictionary) {
            return this.getDictionaryStringValue(ASName.k_ID);
        }
        return null;
    }

    public void setID(ASString id) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryASStringValue(ASName.k_ID, id);
    }

    public ASName requireStructureType() throws PDFInvalidStructureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName type = this.getDictionaryNameValue(ASName.k_S);
        if (type == null) {
            throw new PDFInvalidStructureException("Required instance");
        }
        return type;
    }

    public String getAlt() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Alt);
    }

    public void setAlt(String text) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Alt, text);
    }

    public void setAlt(String text, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Alt, text, unicode);
    }

    public String getLang() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Lang);
    }

    public void setLang(String text) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Lang, text);
    }

    public void setLang(String text, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Lang, text, unicode);
    }

    @Override
    public PDFStructureType getStructureType() {
        return PDFStructureType.Element;
    }
}

