/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;

public class PDFMarkInfo
extends PDFCosDictionary {
    private PDFMarkInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMarkInfo newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMarkInfo pdfObject = new PDFMarkInfo(cosObject);
        return pdfObject;
    }

    public static PDFMarkInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMarkInfo pdfObject = (PDFMarkInfo)PDFCosObject.getCachedInstance(cosObject, PDFMarkInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFMarkInfo(cosObject);
        }
        return pdfObject;
    }

    public boolean getUserProperties() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_UserProperties);
    }

    public void setUserProperties(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_UserProperties, value);
    }

    public boolean hasUserProperties() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_UserProperties);
    }

    public boolean getMarked() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Marked);
    }

    public void setMarked(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Marked, value);
    }

    public boolean hasMarked() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Marked);
    }

    public boolean getSuspects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Suspects);
    }

    public void setSuspects(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Suspects, value);
    }

    public boolean hasSuspects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Suspects);
    }

    public PDFFileSpecificationList getAssociatedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecificationList.getInstance(this.getDictionaryCosObjectValue(ASName.k_AF));
    }

    public void setAssociatedFiles(PDFFileSpecificationList fileSpecificationList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AF, fileSpecificationList);
    }
}

