/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSortIterator;

public class PDFCollectionSort
extends PDFCosDictionary {
    public static final ASName k_CollectionSort = ASName.create("CollectionSort");

    private PDFCollectionSort(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCollectionSort getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionSort pdfObject = (PDFCollectionSort)PDFCosObject.getCachedInstance(cosObject, PDFCollectionSort.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionSort(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionSort newInstance(PDFDocument pdfDocument, ASName[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCollectionSort pdfObject = new PDFCollectionSort(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_CollectionSort);
        pdfObject.setNames(names);
        return pdfObject;
    }

    public PDFCollectionSortIterator getSortIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFCollectionSortIterator(this.getDictionaryValue(ASName.k_S), this.getDictionaryValue(ASName.k_A));
    }

    public ASName[] getNames() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName[] names;
        CosObject cosNames = this.getDictionaryValue(ASName.k_S);
        if (cosNames == null) {
            return null;
        }
        if (cosNames.getType() == 5) {
            int size = ((CosArray)cosNames).size();
            names = new ASName[size];
            for (int arrayInd = 0; arrayInd < size; ++arrayInd) {
                names[arrayInd] = ((CosArray)cosNames).getName(arrayInd);
            }
        } else {
            names = new ASName[]{cosNames.nameValue()};
        }
        return names;
    }

    public void setNames(ASName[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosObject cosNames;
        if (names != null) {
            int size = names.length;
            if (size == 1) {
                cosNames = PDFCosObject.newCosName(this.getPDFDocument(), names[0]);
            } else {
                cosNames = PDFCosObject.newCosArray(this.getPDFDocument());
                for (int arrayInd = 0; arrayInd < size; ++arrayInd) {
                    ((CosArray)cosNames).addName(arrayInd, names[arrayInd]);
                }
            }
        } else {
            throw new PDFInvalidParameterException("S entry of PDFCollectionSort dictionary cant be null");
        }
        this.setDictionaryValue(ASName.k_S, cosNames);
    }

    public boolean hasNames() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public boolean[] getOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean[] names;
        CosObject cosNames = this.getDictionaryValue(ASName.k_A);
        if (cosNames == null) {
            return null;
        }
        if (cosNames.getType() == 5) {
            int size = ((CosArray)cosNames).size();
            names = new boolean[size];
            for (int arrayInd = 0; arrayInd < size; ++arrayInd) {
                names[arrayInd] = ((CosArray)cosNames).getBoolean(arrayInd);
            }
        } else {
            names = new boolean[]{cosNames.booleanValue()};
        }
        return names;
    }

    public void setOrder(boolean[] order) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (order != null) {
            CosObject cosNames;
            int size = order.length;
            if (size == 1) {
                cosNames = PDFCosObject.newCosBoolean(this.getPDFDocument(), order[0]);
            } else {
                cosNames = PDFCosObject.newCosArray(this.getPDFDocument());
                for (int arrayInd = 0; arrayInd < size; ++arrayInd) {
                    ((CosArray)cosNames).addBoolean(arrayInd, order[arrayInd]);
                }
            }
            this.setDictionaryValue(ASName.k_A, cosNames);
        } else {
            this.removeValue(ASName.k_A);
        }
    }

    public boolean hasOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_A);
    }
}

