/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNameIterator;

public class PDFCollectionSchema
extends PDFCosDictionaryMap<PDFCollectionField> {
    public static final ASName k_CollectionSchema = ASName.create("CollectionSchema");

    private PDFCollectionSchema(CosObject cosDict) throws PDFInvalidDocumentException {
        super(cosDict);
    }

    public static PDFCollectionSchema getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionSchema pdfObject = (PDFCollectionSchema)PDFCosObject.getCachedInstance(cosObject, PDFCollectionSchema.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionSchema(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionSchema newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionSchema.newInstance(pdfDocument, true);
    }

    public static PDFCollectionSchema newInstance(PDFDocument pdfDocument, boolean setTypeAttribute) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCollectionSchema pdfObject = new PDFCollectionSchema(cosObject);
        if (setTypeAttribute) {
            pdfObject.setDictionaryNameValue(ASName.k_Type, k_CollectionSchema);
        }
        return pdfObject;
    }

    @Override
    protected PDFCollectionField itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFCollectionField.getInstance(cosObject);
    }

    public PDFCollectionNameIterator getKeyIterator() {
        return new PDFCollectionNameIterator(this);
    }

    public PDFCollectionField get(ASName key) {
        return (PDFCollectionField)super.get(key);
    }

    public void set(ASName key, PDFCollectionField field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (key == null) {
            throw new PDFInvalidDocumentException("Key cannot be null");
        }
        if (field != null) {
            super.put(key, field);
        } else {
            this.remove(key);
        }
    }

    public PDFCollectionField remove(ASName key) throws PDFInvalidDocumentException {
        return (PDFCollectionField)super.remove(key);
    }
}

