/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;

public class PDFCollectionResourcesTree
extends PDFNameTree<PDFStream> {
    private PDFCollectionResourcesTree(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCollectionResourcesTree getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionResourcesTree pdfObject = (PDFCollectionResourcesTree)PDFCosObject.getCachedInstance(cosObject, PDFCollectionResourcesTree.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionResourcesTree(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionResourcesTree newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFCollectionResourcesTree(cosObject);
    }

    @Override
    protected PDFStream makeValueType(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFStream.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

