/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionUtil;
import java.util.ArrayList;

public class PDFCollectionFolder
extends PDFCosDictionary {
    public static final ASName k_Name = ASName.create("Name");
    public static final ASName k_Desc = ASName.create("Desc");
    public static final ASName k_ModDate = ASName.create("ModDate");
    public static final ASName k_CreationDate = ASName.create("CreationDate");
    public static final ASName k_ID = ASName.create("ID");
    public static final ASName k_Parent = ASName.create("Parent");
    public static final ASName k_Next = ASName.create("Next");
    public static final ASName k_Child = ASName.create("Child");
    public static final ASName k_CI = ASName.create("CI");
    public static final ASName k_Thumb = ASName.create("Thumb");
    public static final ASName k_Free = ASName.create("Free");
    public static final ASName k_Folder = ASName.create("Folder");

    private PDFCollectionFolder(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFCollectionFolder(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDoc));
        this.setDictionaryNameValue(ASName.k_Type, k_Folder);
    }

    public static PDFCollectionFolder getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionFolder pdfObject = (PDFCollectionFolder)PDFCosObject.getCachedInstance(cosObject, PDFCollectionFolder.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionFolder(cosObject);
        }
        return pdfObject;
    }

    protected static PDFCollectionFolder newInstanceFolderRoot(PDFDocument pdfDocument, String name, long ID) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFSecurityException {
        PDFCollectionFolder pdfObject = new PDFCollectionFolder(pdfDocument);
        pdfObject.setParent(null);
        pdfObject.setName(null, name);
        pdfObject.setID(ID);
        return pdfObject;
    }

    public static PDFCollectionFolder newInstance(PDFCollectionFolder parent, String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (parent == null) {
            throw new PDFInvalidDocumentException("parent folder cannot be null");
        }
        long newID = PDFCollectionUtil.getNewFolderID(parent.getPDFDocument());
        PDFCollectionFolder folder = new PDFCollectionFolder(parent.getPDFDocument());
        folder.setName(parent, name);
        folder.setParent(parent);
        folder.setID(newID);
        return folder;
    }

    public static PDFCollectionFolder newInstance(PDFCollectionFolder parent, String name, String desc, ASDate creationDate, ASDate modDate, PDFXObject thumbnail, PDFCollectionItem ci) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionFolder folder = PDFCollectionFolder.newInstance(parent, name);
        folder.setDescription(desc);
        folder.setModificationDate(modDate);
        folder.setCreationDate(creationDate);
        folder.setThumb(thumbnail);
        folder.setCollectionItem(ci);
        return folder;
    }

    public ArrayList<PDFCollectionFolder> getChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFCollectionFolder> list = new ArrayList<PDFCollectionFolder>();
        for (PDFCollectionFolder kid = this.getChild(); kid != null; kid = kid.getNext()) {
            list.add(kid);
        }
        return list;
    }

    public ArrayList<PDFCollectionFolder> getSiblings() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFCollectionFolder> list = new ArrayList<PDFCollectionFolder>();
        PDFCollectionFolder parent = this.getParent();
        if (parent == null) {
            list.add(parent);
            return list;
        }
        for (PDFCollectionFolder sibling = parent.getChild(); sibling != null; sibling = sibling.getNext()) {
            list.add(sibling);
        }
        return list;
    }

    public PDFCollectionFolder getChildFolder(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFCollectionFolder> children = this.getChildren();
        for (PDFCollectionFolder child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public PDFCollectionFolder getSiblingFolder(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFCollectionFolder> siblings = this.getSiblings();
        for (PDFCollectionFolder sibling : siblings) {
            if (!sibling.getName().equals(name)) continue;
            return sibling;
        }
        return null;
    }

    public void setName(PDFCollectionFolder parent, String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            throw new PDFInvalidDocumentException("Name is null - it is a required key in Folder");
        }
        if (!this.uniqueName(parent, name)) {
            throw new PDFInvalidDocumentException("Name of folder is not unique");
        }
        PDFText textValue = PDFText.newInstance(this.getPDFDocument(), name);
        ((CosDictionary)this.getCosObject()).put(ASName.k_Name, textValue.getCosObject());
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText textValue = PDFText.getInstance(((CosDictionary)this.getCosObject()).get(ASName.k_Name));
        if (textValue != null) {
            return textValue.stringValue();
        }
        throw new PDFInvalidDocumentException("Name does not exist - it is a required key in Folder");
    }

    public void setDescription(String desc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (desc == null) {
            this.removeValue(k_Desc);
        } else {
            PDFText textValue = PDFText.newInstance(this.getPDFDocument(), desc);
            ((CosDictionary)this.getCosObject()).put(ASName.k_Desc, textValue.getCosObject());
        }
    }

    public String getDescription() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText textValue = PDFText.getInstance(((CosDictionary)this.getCosObject()).get(ASName.k_Desc));
        if (textValue != null) {
            return textValue.stringValue();
        }
        return null;
    }

    public void setModificationDate(ASDate modDate) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (modDate == null) {
            this.removeValue(k_ModDate);
        } else {
            String dateStr = modDate.asString();
            this.setDictionaryStringValue(k_ModDate, dateStr);
        }
    }

    public ASDate getModificationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        if (this.dictionaryContains(k_ModDate)) {
            return new ASDate(this.getDictionaryStringValue(k_ModDate));
        }
        return null;
    }

    public void setCreationDate(ASDate creationDate) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (creationDate == null) {
            this.removeValue(k_CreationDate);
        } else {
            String dateStr = creationDate.asString();
            this.setDictionaryStringValue(k_CreationDate, dateStr);
        }
    }

    public ASDate getCreationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        if (this.dictionaryContains(k_CreationDate)) {
            return new ASDate(this.getDictionaryStringValue(k_CreationDate));
        }
        return null;
    }

    public void setCollectionItem(PDFCollectionItem ci) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (ci == null) {
            this.removeValue(k_CI);
        } else {
            this.setDictionaryValue(k_CI, ci);
        }
    }

    public PDFCollectionItem getCollectionItem() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_CI)) {
            return PDFCollectionItem.getInstance(this.getDictionaryValue(k_CI));
        }
        return null;
    }

    public void setThumb(PDFXObject thumb) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (thumb == null) {
            this.removeValue(k_Thumb);
        } else {
            this.setDictionaryValue(k_Thumb, thumb);
        }
    }

    public PDFXObject getThumb() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_Thumb)) {
            return PDFXObjectFactory.getInstance(this.getDictionaryValue(k_Thumb));
        }
        return null;
    }

    public PDFFileSpecification get(String key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String keyStr;
        ASString asKey;
        PDFNamedEmbeddedFiles nefTree = PDFCollectionUtil.getNEFTree(this.getPDFDocument());
        PDFFileSpecification fileSpec = nefTree.getEntry(asKey = new ASString(PDFDocEncoding.fromUnicodeString(keyStr = "<" + this.getID() + ">" + key, true)));
        if (fileSpec != null) {
            return fileSpec;
        }
        if (PDFCollectionUtil.isRootFolder(this)) {
            asKey = new ASString(PDFDocEncoding.fromUnicodeString(key, true));
            return nefTree.getEntry(asKey);
        }
        return null;
    }

    public void add(PDFCollectionFolder folder, String key, PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFNamedEmbeddedFiles nefTree = PDFCollectionUtil.getNEFTree(this.getPDFDocument());
        String keyStr = "<" + folder.getID() + ">" + key;
        PDFText pdfKey = PDFText.newInstance(keyStr, true, this.getPDFDocument());
        nefTree.addEntry(new ASString(pdfKey.stringValue()), value);
    }

    public byte[] findKey(String key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedEmbeddedFiles nefTree = PDFCollectionUtil.getNEFTree(this.getPDFDocument());
        byte[] notFound = new byte[]{};
        String folderKey = "<" + this.getID() + ">" + key;
        byte[] keyFound = nefTree.findKey(folderKey);
        if (keyFound.length != 0) {
            return keyFound;
        }
        if (PDFCollectionUtil.isRootFolder(this)) {
            return nefTree.findKey(key);
        }
        return notFound;
    }

    protected void setID(long ID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_ID, ID);
    }

    public int getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_ID)) {
            return this.getDictionaryIntValue(k_ID);
        }
        throw new PDFInvalidDocumentException("ID is a required key in Folder");
    }

    private void setParent(PDFCollectionFolder parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (parent != null) {
            this.setDictionaryValue(k_Parent, parent);
            ArrayList<PDFCollectionFolder> children = parent.getChildren();
            if (children.isEmpty()) {
                parent.setDictionaryValue(k_Child, this);
            } else {
                PDFCollectionFolder lastChild = children.get(children.size() - 1);
                lastChild.setDictionaryValue(k_Next, this);
            }
        }
    }

    public PDFCollectionFolder getParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_Parent)) {
            return PDFCollectionFolder.getInstance(this.getDictionaryValue(k_Parent));
        }
        return null;
    }

    public PDFCollectionFolder getChild() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_Child)) {
            return PDFCollectionFolder.getInstance(this.getDictionaryValue(k_Child));
        }
        return null;
    }

    public void setChild(PDFCollectionFolder child) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (child == null) {
            this.removeValue(k_Child);
        } else {
            this.setDictionaryValue(k_Child, child);
        }
    }

    public PDFCollectionFolder getNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_Next)) {
            return PDFCollectionFolder.getInstance(this.getDictionaryValue(k_Next));
        }
        return null;
    }

    public void setNext(PDFCollectionFolder next) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (next == null) {
            this.removeValue(k_Next);
        } else {
            this.setDictionaryValue(k_Next, next);
        }
    }

    protected CosArray getFree() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_Free)) {
            return this.getDictionaryArrayValue(k_Free);
        }
        return null;
    }

    protected void setFree(CosArray free) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (free == null) {
            this.removeValue(k_Free);
        } else {
            this.setDictionaryArrayValue(k_Free, free);
        }
    }

    private boolean uniqueName(PDFCollectionFolder parent, String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (parent == null) {
            return true;
        }
        ArrayList<PDFCollectionFolder> siblings = parent.getChildren();
        for (PDFCollectionFolder sibling : siblings) {
            if (!sibling.getName().equals(name)) continue;
            return false;
        }
        return true;
    }
}

