/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;

public class PDFThumb
extends PDFCosStream {
    private PDFThumb(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFThumb newInstance(PDFDocument pdfDocument, int key_BitsPerComponent, ASName key_ColorSpace, int key_Width, int key_Height) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_ColorSpace == null) {
            throw new PDFInvalidParameterException("ColorSpace is required when creating newInstance of PDFThumb.");
        }
        CosStream cosStream = PDFCosObject.newCosStream(pdfDocument);
        PDFThumb pdfObject = new PDFThumb(cosStream);
        pdfObject.setBitsPerComponent(key_BitsPerComponent);
        pdfObject.setColorSpace(key_ColorSpace);
        pdfObject.setWidth(key_Width);
        pdfObject.setHeight(key_Height);
        return pdfObject;
    }

    public static PDFThumb getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFThumb pdfObject = (PDFThumb)PDFCosObject.getCachedInstance(cosObject, PDFThumb.class);
        if (pdfObject == null) {
            pdfObject = new PDFThumb(cosObject);
        }
        return pdfObject;
    }

    public int getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Width);
    }

    public void setWidth(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Width, value);
    }

    public int requireWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Width);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get Width.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Width);
    }

    public boolean getInterpolate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Interpolate);
    }

    public void setInterpolate(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Interpolate, value);
    }

    public boolean hasInterpolate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Interpolate);
    }

    public int getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Height);
    }

    public void setHeight(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Height, value);
    }

    public int requireHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Height);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Height.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Height);
    }

    public CosArray getDecode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Decode);
    }

    public void setDecode(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Decode, value);
    }

    public boolean hasDecode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Decode);
    }

    public int getBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_BitsPerComponent);
    }

    public void setBitsPerComponent(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_BitsPerComponent, value);
    }

    public int requireBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_BitsPerComponent);
    }

    public boolean hasBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BitsPerComponent);
    }

    public ASName getColorSpaceAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_ColorSpace);
    }

    public void setColorSpace(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("ColorSpace is a required key therefore cannot be removed.");
        }
        this.setDictionaryNameValue(ASName.k_ColorSpace, value);
    }

    public PDFColorSpace getColorSpaceAsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFColorSpaceFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_ColorSpace));
    }

    public void setColorSpace(PDFColorSpace children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            throw new PDFInvalidParameterException("ColorSpace is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_ColorSpace, children.getCosArray());
    }

    public boolean hasColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ColorSpace);
    }
}

