/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationNamed;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageFit;

public abstract class PDFDestination
extends PDFCosObject {
    protected PDFDestination(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDestination getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosObject == null || cosObject.getType() == 0) {
            return null;
        }
        if (cosObject.getType() == 6) {
            return PDFDestination.getInstance(((CosDictionary)cosObject).get(ASName.k_D));
        }
        if (cosObject.getType() == 5) {
            return PDFDestinationExplicit.getInstance(cosObject);
        }
        return PDFDestinationNamed.getInstance((CosScalar)cosObject);
    }

    public static PDFDestinationExplicit newDestXYZ(PDFPage page, float left, float top, float zoom) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestXYZ(page, left, top, zoom);
    }

    public static PDFDestinationExplicit newDestFit(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFit(page);
    }

    public static PDFDestinationExplicit newDestFitH(PDFPage page, float top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitH(page, top);
    }

    public static PDFDestinationExplicit newDestFitV(PDFPage page, float left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitV(page, left);
    }

    public static PDFDestinationExplicit newDestFitR(PDFPage page, float left, float bottom, float right, float top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitR(page, left, bottom, right, top);
    }

    public static PDFDestinationExplicit newDestFitB(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitB(page);
    }

    public static PDFDestinationExplicit newDestFitBH(PDFPage page, float top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitBH(page, top);
    }

    public static PDFDestinationExplicit newDestFitBV(PDFPage page, float left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitBV(page, left);
    }

    public static PDFDestinationExplicit newDestXYZ(PDFDocument pdfDoc, PDFPage page, Double left, Double top, Double zoom) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestXYZ(pdfDoc, page, left, top, zoom);
    }

    public static PDFDestinationExplicit newDestFit(PDFDocument pdfDoc, PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFit(pdfDoc, page);
    }

    public static PDFDestinationExplicit newDestFitH(PDFDocument pdfDoc, PDFPage page, Double top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitH(pdfDoc, page, top);
    }

    public static PDFDestinationExplicit newDestFitV(PDFDocument pdfDoc, PDFPage page, Double left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitV(pdfDoc, page, left);
    }

    public static PDFDestinationExplicit newDestFitR(PDFDocument pdfDoc, PDFPage page, Double left, Double bottom, Double right, Double top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitR(pdfDoc, page, left, bottom, right, top);
    }

    public static PDFDestinationExplicit newDestFitBH(PDFDocument pdfDoc, PDFPage page, Double top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitBH(pdfDoc, page, top);
    }

    public static PDFDestinationExplicit newDestFitBV(PDFDocument pdfDoc, PDFPage page, Double left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.newDestFitBV(pdfDoc, page, left);
    }

    public static PDFDestinationNamed newDestNamed(PDFDocument pdfDocument, ASString key, PDFDestinationExplicit dest) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationNamed.newInstance(pdfDocument, key, dest);
    }

    public abstract PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public abstract PDFPageFit getPageFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public abstract Number[] getCoordinates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public abstract ASString getName() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException;
}

