/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class PDFBookmarkNode
extends PDFCosDictionary {
    protected PDFBookmarkNode(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public PDFBookmark getFirstKid() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBookmark.getInstance(this.getDictionaryCosObjectValue(ASName.k_First));
    }

    public PDFBookmark getLastKid() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBookmark.getInstance(this.getDictionaryCosObjectValue(ASName.k_Last));
    }

    public void setLast(PDFBookmark bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Last, bookmark);
    }

    public void setFirst(PDFBookmark bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_First, bookmark);
    }

    public abstract int getCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public boolean hasCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Count);
    }

    public void setCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Count, count);
    }

    public int getNumKids() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int num = 0;
        for (PDFBookmark kid = this.getFirstKid(); kid != null; kid = kid.getNext()) {
            ++num;
        }
        return num;
    }

    public void setKids(PDFBookmark toInsert) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setFirst(toInsert);
        PDFBookmark lastToInsert = null;
        for (PDFBookmark b = toInsert; b != null; b = b.getNext()) {
            b.setParent(this);
            lastToInsert = b;
        }
        this.setLast(lastToInsert);
    }

    public abstract PDFBookmark findDepthFirst(String var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public Iterator iterator() {
        try {
            return new Iterator();
        }
        catch (PDFInvalidDocumentException e) {
            return null;
        }
        catch (PDFIOException e) {
            return null;
        }
        catch (PDFSecurityException e) {
            return null;
        }
    }

    public class Iterator {
        private PDFBookmark nextBookmark;
        private PDFBookmark lastReturnedBookmark;
        private boolean bookmarkTreeEmpty;
        private final ArrayList<PDFBookmark> bookmarkStack = new ArrayList();
        private Set<Integer> visitedSet = new HashSet<Integer>();

        protected Iterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (PDFBookmarkNode.this instanceof PDFBookmark) {
                this.nextBookmark = (PDFBookmark)PDFBookmarkNode.this;
            } else {
                this.nextBookmark = PDFBookmarkNode.this.getFirstKid();
                if (this.nextBookmark == null) {
                    this.bookmarkTreeEmpty = true;
                }
            }
            if (this.nextBookmark != null) {
                this.bookmarkStack.add(this.nextBookmark);
            }
        }

        public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (!this.bookmarkTreeEmpty && this.lastReturnedBookmark == this.nextBookmark) {
                PDFBookmark firstKid = this.lastReturnedBookmark.getFirstKid();
                if (firstKid != null) {
                    this.nextBookmark = firstKid;
                    this.bookmarkStack.add(firstKid);
                } else {
                    this.nextBookmark = this.lastReturnedBookmark.getNext();
                    if (this.nextBookmark != null) {
                        this.bookmarkStack.set(this.bookmarkStack.size() - 1, this.nextBookmark);
                    } else {
                        while (this.nextBookmark == null && this.bookmarkStack.size() > 1) {
                            this.bookmarkStack.remove(this.bookmarkStack.size() - 1);
                            this.nextBookmark = this.bookmarkStack.get(this.bookmarkStack.size() - 1).getNext();
                            if (this.nextBookmark == null) continue;
                            this.bookmarkStack.set(this.bookmarkStack.size() - 1, this.nextBookmark);
                        }
                    }
                }
            }
            if (this.nextBookmark != null) {
                if (!this.visitedSet.contains(this.nextBookmark.getCosObject().getObjNum())) {
                    return true;
                }
                throw new RuntimeException("Cycle has been detected in Bookmark tree");
            }
            return false;
        }

        public PDFBookmark next() {
            Integer value;
            this.lastReturnedBookmark = this.nextBookmark;
            if (this.nextBookmark != null && (value = Integer.valueOf(this.nextBookmark.getCosObject().getObjNum())) != 0) {
                this.visitedSet.add(value);
            }
            return this.nextBookmark;
        }
    }
}

