/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.geospatial;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFProjectedCoordinateSystem
extends PDFCosDictionary {
    private PDFProjectedCoordinateSystem(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFProjectedCoordinateSystem newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFProjectedCoordinateSystem pdfObject = new PDFProjectedCoordinateSystem(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_PROJCS);
        return pdfObject;
    }

    public static PDFProjectedCoordinateSystem getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFProjectedCoordinateSystem pdfObject = (PDFProjectedCoordinateSystem)PDFCosObject.getCachedInstance(cosObject, PDFProjectedCoordinateSystem.class);
        if (pdfObject == null) {
            pdfObject = new PDFProjectedCoordinateSystem(cosObject);
        }
        return pdfObject;
    }
}

