/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;

public class PDFVariableText
extends PDFCosDictionary {
    private PDFVariableText(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFVariableText getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFVariableText pdfObject = (PDFVariableText)PDFCosObject.getCachedInstance(cosObject, PDFVariableText.class);
        if (pdfObject == null) {
            pdfObject = new PDFVariableText(cosObject);
        }
        return pdfObject;
    }

    public static PDFVariableText newInstance(PDFDocument pdfDoc, String defaultAppearance, String defaultStyle, int quadding, String richText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDoc);
        PDFVariableText varText = new PDFVariableText(cosObject);
        varText.setDefaultAppearance(defaultAppearance);
        varText.setDefaultStyle(defaultStyle);
        varText.setQuadding(quadding);
        varText.setRichText(richText);
        return varText;
    }

    public PDFDefaultAppearance getDefaultAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosValue = PDFCosUtils.getInheritableValue(ASName.k_DA, ASName.k_Parent, this);
        if (cosValue == null) {
            PDFInteractiveForm acroForm = this.getPDFDocument().getInteractiveForm();
            if (acroForm == null) {
                return null;
            }
            cosValue = acroForm.getDictionaryCosObjectValue(ASName.k_DA);
            if (cosValue == null) {
                return null;
            }
        }
        if (cosValue.getType() != 4) {
            return null;
        }
        return PDFDefaultAppearance.getInstance(cosValue);
    }

    public void setDefaultAppearance(String defaultAppearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (defaultAppearance == null) {
            return;
        }
        this.setDictionaryStringValue(ASName.k_DA, defaultAppearance);
    }

    public void setDefaultAppearance(String defaultAppearance, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (defaultAppearance == null) {
            return;
        }
        this.setDictionaryStringValue(ASName.k_DA, defaultAppearance, unicode);
    }

    public void setDefaultAppearance(PDFDefaultAppearance pdfDefaultAppearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDefaultAppearance == null) {
            return;
        }
        this.setDictionaryValue(ASName.k_DA, pdfDefaultAppearance);
    }

    public String getRichText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode field;
        String richText = this.getDictionaryTextStringOrStreamValue(ASName.k_RV);
        if (richText == null && (field = PDFFieldNode.getInstance(this.getCosObject())).isAcrobatAnnotation() && (field = field.getParent()) != null) {
            richText = field.getDictionaryTextStringOrStreamValue(ASName.k_RV);
        }
        return richText;
    }

    public void setRichText(String richText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (richText != null) {
            PDFFieldNode field = PDFFieldNode.getInstance(this.getCosObject());
            if (field.isAcrobatAnnotation()) {
                field = field.getParent();
            }
            if (field != null) {
                field.setDictionaryStringOrStreamValue(ASName.k_RV, richText);
            }
        }
    }

    public String getDefaultStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_DS);
    }

    public void setDefaultStyle(String defaultStyle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (defaultStyle != null) {
            this.setDictionaryStringValue(ASName.k_DS, defaultStyle);
        }
    }

    public void setDefaultStyle(String defaultStyle, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (defaultStyle != null) {
            this.setDictionaryStringValue(ASName.k_DS, defaultStyle, unicode);
        }
    }

    public int getQuadding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosValue = PDFCosUtils.getInheritableValue(ASName.k_Q, ASName.k_Parent, this);
        if (cosValue == null) {
            PDFInteractiveForm acroForm = this.getPDFDocument().getInteractiveForm();
            if (acroForm == null) {
                return 0;
            }
            return acroForm.getDefaultQuadding();
        }
        if (cosValue.getType() != 1) {
            return 0;
        }
        Number qadding = cosValue.numberValue();
        return qadding == null ? 0 : qadding.intValue();
    }

    public void setQuadding(int quadding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (quadding >= 0) {
            this.setDictionaryIntValue(ASName.k_Q, quadding);
        }
    }
}

