/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTemplate;

public class PDFNamedTemplates
extends PDFNameTree<PDFTemplate> {
    private PDFNamedTemplates(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFNamedTemplates getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFNamedTemplates pdfObject = (PDFNamedTemplates)PDFCosObject.getCachedInstance(cosObject, PDFNamedTemplates.class);
        if (pdfObject == null) {
            pdfObject = new PDFNamedTemplates(cosObject);
        }
        return pdfObject;
    }

    public static PDFNamedTemplates newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFNamedTemplates(cosObject);
    }

    @Override
    protected PDFTemplate makeValueType(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFTemplate.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFTemplate value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

