/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;

public class PDFFieldText
extends PDFField {
    public static final int kMultiline = 4096;
    public static final int kPassword = 8192;
    public static final int kFileSelect = 0x100000;
    public static final int kDoNotSpellCheck = 0x400000;
    public static final int kDoNotScroll = 0x800000;
    public static final int kComb = 0x1000000;
    public static final int kRichText = 0x2000000;
    private static final String DEFAULT_TEXTFIELD_NAME = "Text";

    protected PDFFieldText(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldText getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFieldText pdfObject = (PDFFieldText)PDFCosObject.getCachedInstance(cosObject, PDFFieldText.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldText(cosObject);
        }
        return pdfObject;
    }

    public static PDFFieldText newInstance(String qualifiedFieldName, PDFPage page, PDFRectangle annotRect, PDFDefaultAppearance da, boolean combineFieldAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be provided for the annotation when creating fields.");
        }
        if (annotRect == null) {
            throw new PDFInvalidParameterException("An annotation rectangle must be specified when creating fields.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(page.getPDFDocument());
        PDFFieldText field = new PDFFieldText(cosObject);
        PDFInteractiveForm iform = page.getPDFDocument().requireCatalog().procureInteractiveForm();
        PDFFieldNode parent = iform.procureIntermediateFieldNodes(qualifiedFieldName);
        String fieldName = PDFFieldUtils.getTerminalFieldName(qualifiedFieldName);
        field.init(parent, fieldName, page, annotRect, combineFieldAnnot, da);
        return field;
    }

    public static PDFFieldText newInstance(PDFFieldNode parent, PDFPage page, PDFRectangle annotRect, PDFDefaultAppearance da, boolean combineFieldAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (parent == null) {
            throw new PDFInvalidParameterException("A parent field node must be specified when creating fields.");
        }
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be provided for the annotation when creating fields.");
        }
        if (annotRect == null) {
            throw new PDFInvalidParameterException("An annotation rectangle must be specified when creating fields.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(page.getPDFDocument());
        PDFFieldText field = new PDFFieldText(cosObject);
        field.init(parent, null, page, annotRect, combineFieldAnnot, da);
        return field;
    }

    private void init(PDFFieldNode parent, String fieldName, PDFPage page, PDFRectangle annotRect, boolean combineFieldAnnot, PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.init(parent, fieldName, DEFAULT_TEXTFIELD_NAME, da, false);
        this.initWidgetAnnot(page, annotRect, combineFieldAnnot);
        this.setDictionaryNameValue(ASName.k_FT, ASName.k_Tx);
    }

    public boolean hasMaxLen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosValue = PDFCosUtils.getInheritableValue(ASName.k_MaxLen, ASName.k_Parent, this);
        return cosValue != null;
    }

    public int getMaxLen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosValue = PDFCosUtils.getInheritableValue(ASName.k_MaxLen, ASName.k_Parent, this);
        if (cosValue == null || cosValue.getType() != 1) {
            return 0;
        }
        Number maxLen = cosValue.numberValue();
        return maxLen == null ? 0 : maxLen.intValue();
    }

    public void setMaxLen(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_MaxLen, value);
    }

    public boolean getMultiline() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x1000) != 0;
    }

    public void setMultiline(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x1000);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFEFFF);
        }
    }

    public boolean getFileSelect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x100000) != 0;
    }

    public void setFileSelect(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            int flg = this.getFlags();
            this.setFlags(flg |= 0x100000);
        } else {
            int flags = this.getFlags();
            int mask = -1048577;
            this.setFlags(flags &= mask);
        }
    }

    public boolean getDoNotScroll() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x800000) != 0;
    }

    public boolean getDoNotSpellCheck() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x400000) != 0;
    }

    public boolean isComb() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasMaxLen() && (this.getFlags() & 0x1000) == 0 && (this.getFlags() & 0x2000) == 0 && (this.getFlags() & 0x100000) == 0) {
            return (this.getFlags() & 0x1000000) != 0;
        }
        return false;
    }

    public void setComb(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x1000000);
        } else {
            this.setFlags(this.getFlags() & 0xFEFFFFFF);
        }
    }

    public boolean isPassword() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x2000) != 0;
    }

    public void setPassword(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            int flg = this.getFlags();
            this.setFlags(flg |= 0x2000);
        } else {
            int flags = this.getFlags();
            int mask = -8193;
            this.setFlags(flags &= mask);
        }
    }

    public void setdoNotScroll(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x800000);
        } else {
            this.setFlags(this.getFlags() & 0xFF7FFFFF);
        }
    }

    public void setdoNotSpellCheck(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x400000);
        } else {
            this.setFlags(this.getFlags() & 0xFFBFFFFF);
        }
    }

    public boolean isRichText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x2000000) != 0;
    }

    public void setRichText(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x2000000);
        } else {
            this.setFlags(this.getFlags() & 0xFDFFFFFF);
        }
    }

    public String getRichTextForValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFUtil.makeRichTextFromString(this.getDictionaryTextStringOrStreamValue(ASName.k_V));
    }
}

