/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import java.util.Iterator;

public class PDFFieldList
extends PDFCosArrayList<PDFFieldNode> {
    boolean useAcrobatIsTerminalFieldCheck;

    private PDFFieldList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFFieldList.getInstance(cosObject, false);
    }

    protected static PDFFieldList getInstance(CosObject cosObject, boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFieldList pdfObject = (PDFFieldList)PDFCosObject.getCachedInstance(cosObject, PDFFieldList.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldList(cosObject);
        }
        pdfObject.useAcrobatIsTerminalFieldCheck = useAcrobatIsTerminalFieldCheck;
        return pdfObject;
    }

    public static PDFFieldList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFFieldList(cosObject);
    }

    @Override
    protected PDFFieldNode itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldNode.getInstance(cosObject, this.useAcrobatIsTerminalFieldCheck);
    }

    public PDFFieldNode getFieldFullyNamed(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            return null;
        }
        for (PDFFieldNode curField : this) {
            if (!name.equals(curField.getQualifiedName())) continue;
            return curField;
        }
        return null;
    }

    public PDFFieldNode getFieldNamed(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            return null;
        }
        for (PDFFieldNode curField : this) {
            if (curField == null || !name.equals(curField.getPartialName())) continue;
            return curField;
        }
        return null;
    }

    @Override
    public Iterator<PDFFieldNode> iterator() {
        return this.iterator(false);
    }

    public Iterator<PDFFieldNode> iterator(boolean useAcrobatIsTerminalFieldCheck) {
        this.useAcrobatIsTerminalFieldCheck = useAcrobatIsTerminalFieldCheck;
        return super.iterator();
    }

    @Override
    protected Iterator iterator(PDFCosArrayList.PDFObjectFilter filter) {
        return this.iterator(filter, false);
    }

    protected Iterator iterator(PDFCosArrayList.PDFObjectFilter filter, boolean useAcrobatIsTerminalFieldCheck) {
        this.useAcrobatIsTerminalFieldCheck = useAcrobatIsTerminalFieldCheck;
        return super.iterator(filter);
    }
}

