/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;

public class PDFPaperMetaData
extends PDFCosDictionary {
    public static final ASName k_PaperMetaData = ASName.create("PaperMetaData");
    public static final ASName k_Version = ASName.create("Version");
    public static final ASName k_Resolution = ASName.create("Resolution");
    public static final ASName k_Caption = ASName.create("Caption");
    public static final ASName k_Symbology = ASName.create("Symbology");
    public static final ASName k_Width = ASName.create("Width");
    public static final ASName k_Height = ASName.create("Height");
    public static final ASName k_XSymWidth = ASName.create("XSymWidth");
    public static final ASName k_XSymHeight = ASName.create("XSymHeight");
    public static final ASName k_ECC = ASName.create("ECC");
    public static final ASName k_nCodeWordRow = ASName.create("nCodeWordRow");
    public static final ASName k_nCodeWordCol = ASName.create("nCodeWordCol");
    public static final ASName k_PDF417 = ASName.create("PDF417");
    public static final ASName k_QRCode = ASName.create("QRCode");
    public static final ASName k_DataMatrix = ASName.create("DataMatrix");

    private PDFPaperMetaData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPaperMetaData newInstance(PDFDocument pdfDocument, double version, ASName symbology, double width, double height, int xSymWidth, int xSymHeight, int eCC) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (xSymHeight % xSymWidth != 0) {
            throw new PDFInvalidParameterException("According to PDF Reference supplemental, the ratio XSymHeight/XSymWidth shall be an integer value. For PDF417, the acceptable ratio range is from 1 to 4. For QRCode and DataMatrix, this ratio shall always be 1.");
        }
        int ratio = xSymHeight / xSymWidth;
        if (symbology.equals(k_PDF417) && (ratio < 1 || ratio > 4)) {
            throw new PDFInvalidParameterException("According to PDF Reference supplemental, the ratio XSymHeight/XSymWidth shall be an integer value. For PDF417, the acceptable ratio range is from 1 to 4. For QRCode and DataMatrix, this ratio shall always be 1.");
        }
        if ((symbology.equals(k_QRCode) || symbology.equals(k_DataMatrix)) && ratio != 1) {
            throw new PDFInvalidParameterException("According to PDF Reference supplemental, the ratio XSymHeight/XSymWidth shall be an integer value. For PDF417, the acceptable ratio range is from 1 to 4. For QRCode and DataMatrix, this ratio shall always be 1.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFPaperMetaData pdfObject = new PDFPaperMetaData(cosObject);
        pdfObject.setType();
        pdfObject.setVersion(version);
        pdfObject.setSymbology(symbology);
        pdfObject.setWidth(width);
        pdfObject.setHeight(height);
        pdfObject.setXSymWidth(xSymWidth);
        pdfObject.setXSymHeight(xSymHeight);
        pdfObject.setECC(eCC);
        return pdfObject;
    }

    public static PDFPaperMetaData getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPaperMetaData pdfObject = (PDFPaperMetaData)PDFCosObject.getCachedInstance(cosObject, PDFPaperMetaData.class);
        if (pdfObject == null) {
            pdfObject = new PDFPaperMetaData(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, k_PaperMetaData);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public double getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_Version);
    }

    public void setVersion(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_Version, value);
    }

    public boolean hasVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Version);
    }

    public double getResolution() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_Resolution);
    }

    public void setResolution(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Double resolution = new Double(value);
        String numStr = resolution.toString();
        CosNumeric tweakedValue = this.getPDFDocument().getCosDocument().createCosNumeric(numStr.getBytes());
        this.getCosDictionary().put(k_Resolution, tweakedValue);
    }

    public boolean hasResolution() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Resolution);
    }

    public PDFText getCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_Caption));
    }

    public void setCaption(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryTextValue(k_Caption, value);
    }

    public boolean hasCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Caption);
    }

    public ASName getSymbology() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(k_Symbology);
    }

    public void setSymbology(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(k_Symbology);
        } else if (value.equals(ASName.create("PDF417")) || value.equals(ASName.create("QRCode")) || value.equals(ASName.create("DataMatrix"))) {
            this.setDictionaryNameValue(k_Symbology, value);
        } else {
            throw new PDFInvalidParameterException("Symbology " + value + " is outside of bound for Symbology.");
        }
    }

    public boolean hasSymbology() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Symbology);
    }

    public double getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_Width);
    }

    public void setWidth(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_Width, value);
    }

    public boolean hasWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Width);
    }

    public double getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_Height);
    }

    public void setHeight(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_Height, value);
    }

    public boolean hasHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Height);
    }

    public int getXSymWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(k_XSymWidth);
    }

    public void setXSymWidth(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_XSymWidth, value);
    }

    public boolean hasXSymWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_XSymWidth);
    }

    public int getXSymHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(k_XSymHeight);
    }

    public void setXSymHeight(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_XSymHeight, value);
    }

    public boolean hasXSymHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_XSymHeight);
    }

    public int getECC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(k_ECC);
    }

    public void setECC(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getSymbology().equals(k_PDF417) && (value < 0 || value > 8)) {
            throw new PDFInvalidDocumentException("ECC value is out of bound. For PDF417, shall be from 0 to 8. For QRCode, shall be from 0 to 3 (0 for \u0091L\u0092, 1 for \u0091M\u0092, 2 for \u0091Q\u0092, and 3 for \u0091H\u0092).");
        }
        if (this.getSymbology().equals(k_QRCode) && (value < 0 || value > 3)) {
            throw new PDFInvalidDocumentException("ECC value is out of bound. For PDF417, shall be from 0 to 8. For QRCode, shall be from 0 to 3 (0 for \u0091L\u0092, 1 for \u0091M\u0092, 2 for \u0091Q\u0092, and 3 for \u0091H\u0092).");
        }
        this.setDictionaryDoubleValue(k_ECC, value);
    }

    public boolean hasECC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_ECC);
    }

    public double getNCodeWordRow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_nCodeWordRow);
    }

    public void setNCodeWordRow(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_nCodeWordRow, value);
    }

    public boolean hasNCodeWordRow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_nCodeWordRow);
    }

    public double getNCodeWordCol() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_nCodeWordCol);
    }

    public void setNCodeWordCol(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_nCodeWordCol, value);
    }

    public boolean hasNCodeWordCol() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_nCodeWordCol);
    }
}

