/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import java.util.ArrayList;

public class PDFBorder
extends PDFCosArrayList<PDFCosNumeric> {
    private static final double defaultWidth = 1.0;
    private static final double defaultHorizCornerRadius = 0.0;
    private static final double defaultVertCornerRadius = 0.0;

    private PDFBorder(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    @Override
    protected PDFCosNumeric itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFCosNumeric.getInstance(cosObject);
    }

    public static PDFBorder getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFBorder pdfObject = (PDFBorder)PDFCosObject.getCachedInstance(cosObject, PDFBorder.class);
        if (pdfObject == null) {
            pdfObject = new PDFBorder(cosObject);
        }
        return pdfObject;
    }

    public static PDFBorder newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFBorder pdfBorder = new PDFBorder(cosObject);
        pdfBorder.setHorizontalCornerRadius(0.0);
        pdfBorder.setVerticalCornerRadius(0.0);
        pdfBorder.setWidth(1.0);
        return pdfBorder;
    }

    public double getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() != null) {
            return this.getCosArray().getDouble(2);
        }
        throw new PDFInvalidDocumentException("Malformed border array");
    }

    public void setWidth(double width) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObj = this.getCosArray();
        if (cosObj == null) {
            throw new PDFInvalidDocumentException("Malformed border array");
        }
        this.setValueInArray(cosObj, width, 3);
    }

    public void setHorizontalCornerRadius(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObj = this.getCosArray();
        if (cosObj == null) {
            throw new PDFInvalidDocumentException("Malformed border array");
        }
        this.setValueInArray(cosObj, value, 1);
    }

    public double getHorizontalCornerRadius() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (this.getCosArray() != null) {
            return this.getCosArray().getDouble(0);
        }
        throw new PDFInvalidDocumentException("Malformed border array");
    }

    public void setVerticalCornerRadius(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObj = this.getCosArray();
        if (cosObj == null) {
            throw new PDFInvalidDocumentException("Malformed border array");
        }
        this.setValueInArray(cosObj, value, 2);
    }

    public double getVerticalCornerRadius() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (this.getCosArray() != null) {
            return this.getCosArray().getDouble(1);
        }
        throw new PDFInvalidDocumentException("Malformed border array");
    }

    public void setDashPattern(PDFDashPattern dashPattern) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray valueArray = this.convertDashObjtoCosArray(dashPattern);
        CosArray cosObj = this.getCosArray();
        if (cosObj != null && valueArray != null) {
            if (cosObj.size() == 4) {
                cosObj.set(3, valueArray);
            } else {
                cosObj.add(valueArray);
            }
        }
    }

    public PDFDashPattern getDashPattern() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        try {
            CosArray cosDashPattern = null;
            if (this.getCosArray() != null && this.getCosArray().size() >= 4) {
                cosDashPattern = (CosArray)this.getCosArray().get(3);
            }
            return this.convertCosArraytoDashObj(cosDashPattern);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("The document may have an existing erroneous DashPattern set", e);
        }
    }

    private CosArray convertDashObjtoCosArray(PDFDashPattern dashPattern) throws PDFSecurityException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException {
        if (dashPattern == null) {
            return null;
        }
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(dashPattern.getPattern());
        value.add(dashPattern.getPhase());
        return PDFBorder.makeCosArray(this.getPDFDocument(), value);
    }

    private PDFDashPattern convertCosArraytoDashObj(CosArray cosArray) throws PDFSecurityException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException {
        double[] pattern = new double[]{};
        int phase = 0;
        if (cosArray != null) {
            CosArray patternArray = (CosArray)cosArray.get(0);
            pattern = patternArray.getArrayDouble();
            phase = cosArray.getInt(1);
        }
        return new PDFDashPattern(pattern, phase);
    }

    private void setValueInArray(CosArray array, double value, int expectedArraySize) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (array.size() < expectedArraySize) {
            array.addDouble(value);
        } else {
            array.setDouble(expectedArraySize - 1, value);
        }
    }
}

