/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamFilterImpl;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamTransformer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFPaperMetaData;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PDFAnnotationWidget
extends PDFAnnotation {
    public static final Set<ASName> widgetAnnotKeys;
    public static final ASName k_PageFromAnnot;

    private PDFAnnotationWidget(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFAnnotationWidget(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Widget);
    }

    public static PDFAnnotationWidget newInstance(PDFPage page, PDFRectangle annotRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget pdfObject = new PDFAnnotationWidget(page.getPDFDocument());
        pdfObject.setRect(annotRect);
        pdfObject.setPage(page);
        page.addAnnotation(pdfObject);
        return pdfObject;
    }

    public static PDFAnnotationWidget getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationWidget pdfObject = (PDFAnnotationWidget)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationWidget.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationWidget(cosObject);
        }
        return pdfObject;
    }

    public HighlightingMode getHighlightingMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName modeName = this.getDictionaryNameValue(ASName.k_H);
        if (modeName == null) {
            return null;
        }
        try {
            return HighlightingMode.getInstance(modeName.asString(true));
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Invalid highlight mode read from PDF.", e);
        }
    }

    public void removeHighlightingMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_H);
    }

    public boolean hasAppearanceCharacteristics() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MK);
    }

    public PDFAppearanceCharacteristics getAppearanceCharacteristics() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAppearanceCharacteristics.getInstance(this.getDictionaryCosObjectValue(ASName.k_MK));
    }

    public PDFAppearanceCharacteristics procureAppearanceCharacteristics() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAppearanceCharacteristics ap = PDFAppearanceCharacteristics.getInstance(this.getDictionaryCosObjectValue(ASName.k_MK));
        if (ap == null) {
            ap = PDFAppearanceCharacteristics.newInstance(this.getPDFDocument());
            this.setAppearanceCharacteristics(ap);
        }
        return ap;
    }

    public void setAppearanceCharacteristics(PDFAppearanceCharacteristics characteristics) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_MK, characteristics);
    }

    @Override
    public PDFAdditionalActions getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAdditionalActions.getInstance(this.getDictionaryDictionaryValue(ASName.k_AA), null);
    }

    public PDFField getParentField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFField.getInstance(this.getDictionaryCosObjectValue(ASName.k_Parent));
    }

    public boolean isField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getSubtype() != ASName.k_Widget) {
            return false;
        }
        return PDFFieldUtils.containsPureFieldKeys(this);
    }

    public PDFField getField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFField.getInstance(this.getCosDictionary());
    }

    public void setParentField(PDFField parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Parent, parent);
    }

    public PDFPaperMetaData getPMD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPaperMetaData.getInstance(this.getDictionaryDictionaryValue(ASName.k_PMD));
    }

    public void setPMD(PDFPaperMetaData value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PMD, value);
    }

    public boolean hasPMD() {
        return this.getCosDictionary().containsKey(ASName.k_PMD);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFDefaultAppearance defaultAppearance;
        PDFVariableText pdfVariableText;
        PDFField pdfFieldNode;
        PDFAppearanceCharacteristics appearanceCharacteristics = this.hasAppearanceCharacteristics() ? this.getAppearanceCharacteristics() : PDFAppearanceCharacteristics.newInstance(this.getPDFDocument());
        int rotation = appearanceCharacteristics.hasRotation() ? (int)Math.toDegrees((Math.toRadians(appearanceCharacteristics.getRotation().getValue()) + rotationAngle) % Math.PI) : (int)Math.toDegrees(rotationAngle);
        PDFRotation pdfRotation = PDFRotation.getInstance(rotation);
        appearanceCharacteristics.setRotation(pdfRotation);
        this.setAppearanceCharacteristics(appearanceCharacteristics);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
        ASMatrix unRotatedMatrix = matrix.rotate(-rotationAngle);
        double scaleX = unRotatedMatrix.geta();
        double scaleY = unRotatedMatrix.getd();
        double scale = Math.min(scaleX, scaleY);
        if (scale != 1.0 && this.isField() && (pdfFieldNode = this.getField()) != null && (pdfVariableText = pdfFieldNode.getVariableText()) != null && (defaultAppearance = pdfVariableText.getDefaultAppearance()) != null) {
            PDFDefaultAppearance newApearance = this.scaleDefaultAppearance(defaultAppearance, scale);
            pdfVariableText.setDefaultAppearance(newApearance);
        }
    }

    private PDFDefaultAppearance scaleDefaultAppearance(PDFDefaultAppearance defaultAppearance, final double scale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (defaultAppearance == null) {
            throw new PDFInvalidParameterException("Default Appearance is null");
        }
        InputByteStream ibs = null;
        try {
            byte[] bytes = defaultAppearance.asByteArray();
            if (bytes != null) {
                PDFDocument pdfDocument = this.getPDFDocument();
                ModifiableContent content = ModifiableContent.newInstance(defaultAppearance);
                ContentWriter writer = ContentWriter.newInstance(pdfDocument);
                writer.setInstructionDelimiter(32);
                try {
                    ibs = ContentStreamTransformer.transformContent(content, new ContentStreamFilterImpl(){

                        @Override
                        public void Tf(ASName fontName, double fontSize, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                            if (fontSize == 0.0) {
                                super.Tf(fontName, fontSize, instruction);
                            } else {
                                double newFontSize = fontSize * scale;
                                super.Tf(fontName, newFontSize, InstructionFactory.newTextFont(fontName, newFontSize));
                            }
                        }
                    }, writer);
                }
                catch (PDFFontException e) {
                    throw new PDFInvalidDocumentException(e);
                }
                byte[] newBytes = IO.inputByteStreamToArray(ibs);
                PDFDefaultAppearance pDFDefaultAppearance = PDFDefaultAppearance.newInstance(pdfDocument, newBytes);
                return pDFDefaultAppearance;
            }
            PDFDefaultAppearance pDFDefaultAppearance = null;
            return pDFDefaultAppearance;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            if (ibs != null) {
                try {
                    ibs.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setHighlight(String highlight) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (highlight == null) {
            this.removeHighlightingMode();
        } else {
            PDFAnnotationUtils.setHighlight(highlight, this);
        }
    }

    static {
        HashSet<ASName> tempWidgetAnnotKeys = new HashSet<ASName>();
        tempWidgetAnnotKeys.add(ASName.k_Type);
        tempWidgetAnnotKeys.add(ASName.k_Subtype);
        tempWidgetAnnotKeys.add(ASName.k_Rect);
        tempWidgetAnnotKeys.add(ASName.k_Contents);
        tempWidgetAnnotKeys.add(ASName.k_P);
        tempWidgetAnnotKeys.add(ASName.k_NM);
        tempWidgetAnnotKeys.add(ASName.k_M);
        tempWidgetAnnotKeys.add(ASName.k_F);
        tempWidgetAnnotKeys.add(ASName.k_AP);
        tempWidgetAnnotKeys.add(ASName.k_AS);
        tempWidgetAnnotKeys.add(ASName.k_Border);
        tempWidgetAnnotKeys.add(ASName.k_C);
        tempWidgetAnnotKeys.add(ASName.k_StructParent);
        tempWidgetAnnotKeys.add(ASName.k_OC);
        tempWidgetAnnotKeys.add(ASName.k_H);
        tempWidgetAnnotKeys.add(ASName.k_MK);
        tempWidgetAnnotKeys.add(ASName.k_A);
        tempWidgetAnnotKeys.add(ASName.k_BS);
        tempWidgetAnnotKeys.add(ASName.k_PMD);
        widgetAnnotKeys = Collections.unmodifiableSet(tempWidgetAnnotKeys);
        k_PageFromAnnot = ASName.create("PageFromAnnot");
    }

    public static final class HighlightingMode {
        private final String mode;
        public static final HighlightingMode None = new HighlightingMode("N");
        public static final HighlightingMode Invert = new HighlightingMode("I");
        public static final HighlightingMode Outline = new HighlightingMode("O");
        public static final HighlightingMode Push = new HighlightingMode("P");
        public static final HighlightingMode Toggle = new HighlightingMode("T");

        private HighlightingMode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            String modeStr = null;
            modeStr = "N".equals(this.mode) ? "None" : ("I".equals(this.mode) ? "Invert" : ("O".equals(this.mode) ? "Outline" : ("P".equals(this.mode) ? "Push" : ("T".equals(this.mode) ? "Toggle" : "Unrecognized Mode"))));
            return modeStr;
        }

        String getValue() {
            return this.mode;
        }

        private static HighlightingMode getInstance(char modeValue) throws PDFInvalidParameterException {
            HighlightingMode mode = null;
            switch (modeValue) {
                case 'N': {
                    mode = None;
                    break;
                }
                case 'I': {
                    mode = Invert;
                    break;
                }
                case 'O': {
                    mode = Outline;
                    break;
                }
                case 'P': {
                    mode = Push;
                    break;
                }
                case 'T': {
                    mode = Toggle;
                    break;
                }
                default: {
                    throw new PDFInvalidParameterException("Illegal highlighting mode value.");
                }
            }
            return mode;
        }

        private static HighlightingMode getInstance(String modeStr) throws PDFInvalidParameterException {
            if (modeStr == null) {
                return null;
            }
            char modeValue = modeStr.charAt(0);
            return HighlightingMode.getInstance(modeValue);
        }
    }
}

