/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithQuadPoints;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;

public abstract class PDFAnnotationTextMarkup
extends PDFAnnotationMarkup
implements PDFAnnotationWithQuadPoints {
    protected PDFAnnotationTextMarkup(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    protected PDFAnnotationTextMarkup(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
    }

    @Override
    public boolean hasQuadPoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_QuadPoints);
    }

    @Override
    public double[] getQuadPoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosQuadPoints = this.getDictionaryArrayValue(ASName.k_QuadPoints);
        return cosQuadPoints.getArrayDouble();
    }

    @Override
    public void setQuadPoints(String points, String separator) throws PDFInvalidDocumentException, PDFInvalidParameterException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_QuadPoints, PDFUtil.parseNumbers(points, separator));
    }

    @Override
    public void setQuadPoints(double[] quadPoints) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (quadPoints == null) {
            this.removeValue(ASName.k_QuadPoints);
            return;
        }
        CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
        for (int i = 0; i < quadPoints.length; ++i) {
            cosArray.addDouble(quadPoints[i]);
        }
        this.setDictionaryArrayValue(ASName.k_QuadPoints, cosArray);
    }

    @Override
    public void transformQuadPoints(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasQuadPoints()) {
            double[] quadPoints = this.getQuadPoints();
            double[] newQuagPoints = new double[quadPoints.length];
            for (int i = 0; i < quadPoints.length; i += 2) {
                ASCoordinate point = new ASCoordinate(quadPoints[i], quadPoints[i + 1]);
                ASCoordinate newPoint = point.transform(matrix);
                newQuagPoints[i] = newPoint.x();
                newQuagPoints[i + 1] = newPoint.y();
            }
            this.setQuadPoints(newQuagPoints);
        }
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.transformQuadPoints(matrix);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedPopupRect = null;
        double[] transformedQuadPoints = null;
        PDFAnnotationPopup popup = this.getPopup();
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        transformedQuadPoints = PDFAnnotationUtils.transfromRectangle(this.getQuadPoints(), width, height, rotationAngle);
        if (popup != null) {
            transformedPopupRect = PDFAnnotationUtils.transfromRectangle(this.getPopup().getRect().getValues(), width, height, rotationAngle);
        }
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
        this.setQuadPoints(transformedQuadPoints);
        if (popup != null) {
            this.getPopup().setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedPopupRect[0], transformedPopupRect[1], transformedPopupRect[2], transformedPopupRect[3]));
        }
    }
}

