/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFAnnotationMovie
extends PDFAnnotation {
    private PDFAnnotationMovie(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationMovie newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationMovie(pdfDocument);
    }

    private PDFAnnotationMovie(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Movie);
    }

    public static PDFAnnotationMovie getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationMovie pdfObject = (PDFAnnotationMovie)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationMovie.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationMovie(cosObject);
        }
        return pdfObject;
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int rotation = this.hasRotation() ? (int)Math.toDegrees((Math.toRadians(this.getRotation()) + rotationAngle) % Math.PI) : (int)Math.toDegrees(rotationAngle);
        this.setRotation(rotation);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    public PDFCosDictionary getMovie() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDFMovie", this.getDictionaryCosObjectValue(ASName.k_Movie));
    }

    public void setMovie(PDFCosDictionary movie) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMovie", movie);
        if (movie == null) {
            throw new PDFInvalidParameterException("Movie can't be null");
        }
        this.setDictionaryValue(ASName.k_Movie, movie);
    }

    public boolean movieActivationInfoIsFlag() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().get(ASName.k_A) instanceof CosBoolean;
    }

    public boolean movieActivationInfoIsDictionary() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().get(ASName.k_A) instanceof CosDictionary;
    }

    public void setMovieActivationInfoAsFlag(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_A, value);
    }

    public void setMovieActivationInfoAsDictionary(PDFCosDictionary movieActivationDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMovieActivation", movieActivationDict);
        this.setDictionaryValue(ASName.k_A, movieActivationDict);
    }

    public boolean getMovieActivationInfoAsFlag() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_A);
    }

    public PDFCosDictionary getMovieActivationInfoAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDFMovieActivation", this.getDictionaryCosObjectValue(ASName.k_A));
    }
}

