/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithFringe;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIntent;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFFreeTextIntentValue;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;

public class PDFAnnotationFreeText
extends PDFAnnotationMarkup
implements PDFAnnotationWithFringe,
PDFAnnotationWithIntent,
PDFAnnotationWithBorderEffects {
    private PDFAnnotationFreeText(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationFreeText newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationFreeText(pdfDocument);
    }

    private PDFAnnotationFreeText(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_FreeText);
    }

    public static PDFAnnotationFreeText getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationFreeText pdfObject = (PDFAnnotationFreeText)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationFreeText.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationFreeText(cosObject);
        }
        return pdfObject;
    }

    public String getDefaultAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_DA);
    }

    public PDFDefaultAppearance getDefaultFreeTextAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosValue = PDFCosUtils.getInheritableValue(ASName.k_DA, ASName.k_Parent, this);
        if (cosValue == null) {
            PDFInteractiveForm acroForm = this.getPDFDocument().getInteractiveForm();
            if (acroForm == null) {
                return null;
            }
            cosValue = acroForm.getDictionaryCosObjectValue(ASName.k_DA);
            if (cosValue == null) {
                return null;
            }
        }
        if (cosValue.getType() != 4) {
            return null;
        }
        return PDFDefaultAppearance.getInstance(cosValue);
    }

    public void setDefaultAppearance(PDFDefaultAppearance pdfDefaultAppearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDefaultAppearance == null) {
            return;
        }
        this.setDictionaryValue(ASName.k_DA, pdfDefaultAppearance);
    }

    public void setDefaultAppearance(String appearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DA, appearance);
    }

    public void setDefaultAppearance(String appearance, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DA, appearance, unicode);
    }

    public boolean hasJustification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Q);
    }

    public int getJustification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(ASName.k_Q);
        return value != null ? value.intValue() : 0;
    }

    public void setJustification(int justification) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Q, justification);
    }

    public String getDefaultStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_DS);
    }

    public void setDefaultStyle(String style) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DS, style);
    }

    public void setDefaultStyle(String style, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DS, style, unicode);
    }

    public double[] getCalloutLine() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosQuadPoints = this.getDictionaryArrayValue(ASName.k_CL);
        if (cosQuadPoints == null) {
            return null;
        }
        return cosQuadPoints.getArrayDouble();
    }

    public void setCalloutLine(double x1, double y1, double x2, double y2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosCallout = PDFCosObject.newCosArray(this.getPDFDocument());
        cosCallout.addDouble(x1);
        cosCallout.addDouble(y1);
        cosCallout.addDouble(x2);
        cosCallout.addDouble(y2);
        this.setDictionaryArrayValue(ASName.k_CL, cosCallout);
    }

    public void setCalloutLine(double[] callout) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (callout != null) {
            if (callout.length == 4) {
                this.setCalloutLine(callout[0], callout[1], callout[2], callout[3]);
            } else if (callout.length == 6) {
                this.setCalloutLine(callout[0], callout[1], callout[2], callout[3], callout[4], callout[5]);
            }
        }
    }

    public void setCalloutLine(String points, String separator) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_CL, PDFUtil.parseNumbers(points, separator));
    }

    public void setCalloutLine(double x1, double y1, double x2, double y2, double x3, double y3) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosCallout = PDFCosObject.newCosArray(this.getPDFDocument());
        cosCallout.addDouble(x1);
        cosCallout.addDouble(y1);
        cosCallout.addDouble(x2);
        cosCallout.addDouble(y2);
        cosCallout.addDouble(x3);
        cosCallout.addDouble(y3);
        this.setDictionaryArrayValue(ASName.k_CL, cosCallout);
    }

    @Override
    protected boolean isIntentTypeValid(String intentType) {
        return PDFFreeTextIntentValue.getInstance(intentType) != null;
    }

    private void transformCalloutLine(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] calloutLine = this.getCalloutLine();
        if (calloutLine != null) {
            for (int i = 0; i < calloutLine.length; i += 2) {
                ASCoordinate coordinate = new ASCoordinate(calloutLine[i], calloutLine[i + 1]);
                ASCoordinate newCoordinate = coordinate.transform(matrix);
                calloutLine[i] = newCoordinate.x();
                calloutLine[i + 1] = newCoordinate.y();
            }
            if (calloutLine.length == 4) {
                this.setCalloutLine(calloutLine[0], calloutLine[1], calloutLine[2], calloutLine[3]);
            } else if (calloutLine.length == 6) {
                this.setCalloutLine(calloutLine[0], calloutLine[1], calloutLine[2], calloutLine[3], calloutLine[4], calloutLine[5]);
            }
        }
    }

    @Override
    public PDFBorderEffects getBorderEffects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBorderEffects.getInstance(this.getDictionaryCosObjectValue(ASName.k_BE));
    }

    @Override
    public void setBorderEffects(PDFBorderEffects borderEffects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_BE, borderEffects);
    }

    @Override
    public double[] getFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationWithFringe.FringeGetterSetter.getFringe(this);
    }

    @Override
    public void setFringe(String fringe, String separator) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFAnnotationWithFringe.FringeGetterSetter.setFringe(this, fringe, separator);
    }

    @Override
    public void setFringe(double[] fringe) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFAnnotationWithFringe.FringeGetterSetter.setFringe(this, fringe);
    }

    @Override
    public boolean hasFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_RD);
    }

    public boolean hasCallout() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CL);
    }

    public boolean hasLineEnds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_LE);
    }

    public ASName getLineEnds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName cosName = this.getDictionaryNameValue(ASName.k_LE);
        return cosName != null ? cosName : ASName.k_None;
    }

    public void setLineEnds(PDFAnnotationLine.LineEnding[] lineEndings) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName le = ASName.create("none");
        for (int i = 0; i < lineEndings.length; ++i) {
            if (lineEndings[i].getValue() == null) continue;
            le = lineEndings[i].getValue();
        }
        this.setDictionaryNameValue(ASName.k_LE, le);
    }

    @Override
    public void transformFringe(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFringe(PDFAnnotationUtils.transformFringe(this, matrix, rotationAngle, this.getFringe()));
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformFringe(matrix, rotationAngle);
        this.transformCalloutLine(matrix);
        int rotation = this.hasRotation() ? (int)Math.toDegrees((Math.toRadians(this.getRotation()) + rotationAngle) % Math.PI) : (int)Math.toDegrees(rotationAngle);
        this.setRotation(rotation);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    @Override
    public PDFBorderEffects procureBorderEffects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderEffects borderEffects = this.getBorderEffects();
        if (borderEffects == null) {
            borderEffects = PDFBorderEffects.newInstance(this.getPDFDocument());
        }
        return borderEffects;
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        double[] calloutLine;
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedFringe = null;
        double[] transformedPopupRect = null;
        double[] transformedCalloutLine = null;
        PDFAnnotationPopup popup = this.getPopup();
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]).normalized(this.getPDFDocument()));
        double[] fringeRectangle = this.getFringe();
        if (fringeRectangle != null) {
            transformedFringe = PDFAnnotationUtils.transfromRectangle(fringeRectangle, width, height, rotationAngle);
            this.setFringe(transformedFringe);
        }
        if ((calloutLine = this.getCalloutLine()) != null) {
            transformedCalloutLine = PDFAnnotationUtils.transfromRectangle(calloutLine, width, height, rotationAngle);
            this.setCalloutLine(transformedCalloutLine);
        }
        if (popup != null) {
            transformedPopupRect = PDFAnnotationUtils.transfromRectangle(this.getPopup().getRect().getValues(), width, height, rotationAngle);
            this.getPopup().setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedPopupRect[0], transformedPopupRect[1], transformedPopupRect[2], transformedPopupRect[3]));
        }
    }
}

