/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMovie;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPrinterMark;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationProjection;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRichMedia;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationScreen;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSound;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquiggly;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStrikeOut;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationTrapNet;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnknown;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWatermark;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;

public class PDFAnnotationFactory {
    public static PDFAnnotation getInstance(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(cosObject instanceof CosDictionary)) {
            return null;
        }
        CosObject cosSubtype = ((CosDictionary)cosObject).get(ASName.k_Subtype);
        if (!(cosSubtype instanceof CosName)) {
            return PDFAnnotationUnknown.getInstance(cosObject);
        }
        ASName nameSubtype = cosSubtype.nameValue();
        if (nameSubtype == ASName.k_Text) {
            return PDFAnnotationText.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Link) {
            return PDFAnnotationLink.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_FreeText) {
            return PDFAnnotationFreeText.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Line) {
            return PDFAnnotationLine.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Square) {
            return PDFAnnotationSquare.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Circle) {
            return PDFAnnotationCircle.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Highlight) {
            return PDFAnnotationHighlight.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Underline) {
            return PDFAnnotationUnderline.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Squiggly) {
            return PDFAnnotationSquiggly.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_StrikeOut) {
            return PDFAnnotationStrikeOut.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Stamp) {
            return PDFAnnotationStamp.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Ink) {
            return PDFAnnotationInk.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Popup) {
            return PDFAnnotationPopup.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_FileAttachment) {
            return PDFAnnotationFileAttachment.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Sound) {
            return PDFAnnotationSound.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_PolyLine) {
            return PDFAnnotationPolyline.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Polygon) {
            return PDFAnnotationPolygon.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Movie) {
            return PDFAnnotationMovie.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Widget) {
            return PDFAnnotationWidget.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Caret) {
            return PDFAnnotationCaret.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Watermark) {
            return PDFAnnotationWatermark.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_PrinterMark) {
            return PDFAnnotationPrinterMark.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_TrapNet) {
            return PDFAnnotationTrapNet.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Redact) {
            return PDFAnnotationRedaction.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Screen) {
            return PDFAnnotationScreen.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_3D) {
            return PDFAnnotation3D.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_Projection) {
            return PDFAnnotationProjection.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_RichMedia) {
            return PDFAnnotationRichMedia.getInstance(cosObject);
        }
        return PDFAnnotationUnknown.getInstance(cosObject);
    }
}

