/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFNamedDestinations;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFEmbeddedTarget
extends PDFCosDictionary {
    private PDFEmbeddedTarget(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFEmbeddedTarget(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
        this.setRelationship(ASName.k_P);
    }

    public static PDFEmbeddedTarget getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFEmbeddedTarget pdfObject = (PDFEmbeddedTarget)PDFCosObject.getCachedInstance(cosObject, PDFEmbeddedTarget.class);
        if (pdfObject == null) {
            pdfObject = new PDFEmbeddedTarget(cosObject);
        }
        return pdfObject;
    }

    public static PDFEmbeddedTarget newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEmbeddedTarget pdfObject = new PDFEmbeddedTarget(pdfDocument);
        return pdfObject;
    }

    public static PDFEmbeddedTarget newInstance(PDFDocument pdfDocument, ASString embeddedFileName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary targetObj = PDFCosObject.newCosDictionary(pdfDocument);
        targetObj.put(ASName.k_R, ASName.k_C);
        if (embeddedFileName == null) {
            throw new PDFInvalidParameterException("Embedded file name is required.");
        }
        targetObj.put(ASName.k_N, embeddedFileName);
        PDFEmbeddedTarget target = PDFEmbeddedTarget.getInstance(targetObj);
        return target;
    }

    public static PDFEmbeddedTarget newInstance(PDFDocument pdfDocument, Object fileAttachAnnotPage, Object fileAttachAnnotLocation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary targetObj = PDFCosObject.newCosDictionary(pdfDocument);
        targetObj.put(ASName.k_R, ASName.k_C);
        PDFEmbeddedTarget target = PDFEmbeddedTarget.getInstance(targetObj);
        if (fileAttachAnnotPage != null && (fileAttachAnnotPage instanceof Integer || fileAttachAnnotPage instanceof ASString)) {
            if (fileAttachAnnotPage instanceof Integer) {
                targetObj.put(ASName.k_P, (Integer)fileAttachAnnotPage);
            } else {
                target.setDictionaryASStringValue(ASName.k_P, (ASString)fileAttachAnnotPage);
            }
        } else {
            throw new PDFInvalidParameterException("File attachment annot page is required.");
        }
        if (fileAttachAnnotLocation != null && (fileAttachAnnotLocation instanceof Integer || fileAttachAnnotLocation instanceof String)) {
            if (fileAttachAnnotLocation instanceof Integer) {
                targetObj.put(ASName.k_A, (Integer)fileAttachAnnotPage);
            } else {
                target.setDictionaryStringValue(ASName.k_A, (String)fileAttachAnnotPage);
            }
        } else {
            throw new PDFInvalidParameterException("File attachment annot location is required.");
        }
        return target;
    }

    public ASName getRelationship() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_R);
    }

    public void setRelationship(ASName r) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_R, r);
    }

    public int getPageIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_P)) {
            return -1;
        }
        CosObject cosObj = this.getDictionaryCosObjectValue(ASName.k_P);
        if (cosObj.getType() == 1) {
            return this.getDictionaryIntValue(ASName.k_P);
        }
        if (cosObj.getType() == 4) {
            ASString name = this.getDictionaryStringValue(ASName.k_P);
            PDFNameDictionary nameDict = this.getPDFDocument().requireCatalog().getNameDictionary();
            if (nameDict == null) {
                return -1;
            }
            PDFNamedDestinations namedDests = nameDict.getNamedDestinations();
            if (namedDests == null) {
                return -1;
            }
            PDFDestination dest = (PDFDestination)namedDests.getEntry(name);
            if (dest == null) {
                return -1;
            }
            PDFPage page = dest.getPage();
            if (page == null) {
                return -1;
            }
            return page.getIndex();
        }
        return -1;
    }

    public void setPageIndex(int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_P, index);
    }

    public int getAnnotationIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_A)) {
            return -1;
        }
        CosObject cosObj = this.getDictionaryCosObjectValue(ASName.k_A);
        if (cosObj.getType() == 1) {
            return this.getDictionaryIntValue(ASName.k_A);
        }
        return -1;
    }

    public void setAnnotationIndex(int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_A, index);
    }

    public String getAnnotationName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_A)) {
            return null;
        }
        CosObject cosObj = this.getDictionaryCosObjectValue(ASName.k_A);
        if (cosObj.getType() == 4) {
            return this.getDictionaryTextStringValue(ASName.k_A);
        }
        return null;
    }

    public void setAnnotationName(String annotName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_A, annotName);
    }

    public void setAnnotationName(String annotName, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_A, annotName, unicode);
    }

    public ASString getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_N)) {
            return null;
        }
        return this.getDictionaryStringValue(ASName.k_N);
    }

    public void setName(ASString name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryASStringValue(ASName.k_N, name);
    }

    public PDFEmbeddedTarget getEmbeddedTarget() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_T)) {
            return null;
        }
        return PDFEmbeddedTarget.getInstance(this.getDictionaryCosObjectValue(ASName.k_T));
    }

    public void setEmbeddedTarget(PDFEmbeddedTarget target) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_T, target);
    }
}

