/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;

public class PDFAdditionalActionsField
extends PDFAdditionalActions {
    private PDFAdditionalActionsField(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFAdditionalActionsField(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public static PDFAdditionalActionsField getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAdditionalActionsField pdfObject = (PDFAdditionalActionsField)PDFCosObject.getCachedInstance(cosObject, PDFAdditionalActionsField.class);
        if (pdfObject == null) {
            pdfObject = new PDFAdditionalActionsField(cosObject);
        }
        return pdfObject;
    }

    public static PDFAdditionalActionsField newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAdditionalActionsField pdfObject = new PDFAdditionalActionsField(pdfDocument);
        return pdfObject;
    }

    @Override
    protected PDFAction itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(cosObject);
    }

    public PDFAction getActionOnKeystroke() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_K));
    }

    public void setActionOnKeystroke(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_K, action);
    }

    public PDFAction getActionOnFormat() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_F));
    }

    public void setActionOnFormat(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_F, action);
    }

    public PDFAction getActionOnChange() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_V));
    }

    public void setActionOnChange(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_V, action);
    }

    public PDFAction getActionOnCalculate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_C));
    }

    public void setActionOnCalculate(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_C, action);
    }

    public PDFAction getAction(ASName actionNane) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(actionNane));
    }
}

