/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBead;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;

public class PDFActionThread
extends PDFAction {
    private PDFActionThread(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionThread(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_Thread);
    }

    public static PDFActionThread getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionThread pdfObject = (PDFActionThread)PDFCosObject.getCachedInstance(cosObject, PDFActionThread.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionThread(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionThread newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return new PDFActionThread(pdfDocument);
    }

    public boolean hasDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }

    public PDFDestination getDestination() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFDestination.getInstance(this.getDictionaryCosObjectValue(ASName.k_D));
    }

    public void setDestination(PDFDestination pdfDestination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_D, pdfDestination);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification pdfFileSpecification) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_F, pdfFileSpecification);
    }

    public boolean hasBead() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_B);
    }

    public PDFBead getBead() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBead.getInstance(this.getDictionaryCosObjectValue(ASName.k_B));
    }

    public void setBead(PDFBead bead) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_B, bead);
    }
}

