/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;

public class PDFActionSetState
extends PDFAction {
    private PDFActionSetState(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionSetState(PDFDocument pdfDocument, CosDictionary key_T) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(pdfDocument);
        this.setSubtype(ASName.create("set-state"));
        this.setT(key_T);
    }

    public static PDFActionSetState newInstance(PDFDocument pdfDocument, CosDictionary key_T) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_T == null) {
            throw new PDFInvalidParameterException("T is required when creating newInstance of PDFActionSetState.");
        }
        return new PDFActionSetState(pdfDocument, key_T);
    }

    public static PDFActionSetState getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionSetState pdfObject = (PDFActionSetState)PDFCosObject.getCachedInstance(cosObject, PDFActionSetState.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionSetState(cosObject);
        }
        return pdfObject;
    }

    public ASName getAS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_AS);
    }

    public void setAS(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryNameValue(ASName.k_AS, value);
    }

    public boolean hasAS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AS);
    }

    public CosDictionary getTAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(ASName.k_T);
    }

    public void setT(CosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("T is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_T, value);
    }

    public ASString getTAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_T);
    }

    public void setT(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("T is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_T, value);
    }

    public void setT(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("T is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_T, value);
    }

    public CosArray getTAsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_T);
    }

    public void setT(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("T is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_T, value);
    }

    public boolean hasT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_T);
    }
}

