/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFWindowsLaunchParameters;

public class PDFActionLaunch
extends PDFAction {
    private PDFActionLaunch(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionLaunch(PDFDocument pdfDocument, PDFFileSpecification file) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_Launch);
        this.setFileSpecification(file);
    }

    public static PDFActionLaunch getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionLaunch pdfObject = (PDFActionLaunch)PDFCosObject.getCachedInstance(cosObject, PDFActionLaunch.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionLaunch(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionLaunch newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionGoTo = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionGoTo.put(ASName.k_Type, ASName.k_Action);
        cosActionGoTo.put(ASName.k_S, ASName.k_Launch);
        return new PDFActionLaunch(cosActionGoTo);
    }

    public static PDFActionLaunch newInstance(PDFDocument pdfDocument, PDFFileSpecification file) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (file == null) {
            throw new PDFInvalidDocumentException("File Specification is a required key");
        }
        return new PDFActionLaunch(pdfDocument, file);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification file) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (file == null) {
            throw new PDFInvalidDocumentException("File Specification is a required key");
        }
        this.setDictionaryValue(ASName.k_F, file);
    }

    public boolean hasNewWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NewWindow);
    }

    public boolean getNewWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_NewWindow);
    }

    public void setNewWindow(boolean newWindow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NewWindow, newWindow);
    }

    public boolean hasWindowsLaunchParameters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Win);
    }

    public PDFWindowsLaunchParameters getWindowsLaunchParameters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFWindowsLaunchParameters.getInstance(this.getDictionaryCosObjectValue(ASName.k_Win));
    }

    public void setWindowsLaunchParameters(PDFWindowsLaunchParameters win) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Win, win);
    }
}

