/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFValueContainer;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;

public class PDFActionFormReset
extends PDFActionForm {
    private PDFActionFormReset(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFActionFormReset(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_ResetForm);
    }

    public static PDFActionFormReset getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionFormReset pdfObject = (PDFActionFormReset)PDFCosObject.getCachedInstance(cosObject, PDFActionFormReset.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionFormReset(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionFormReset newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFActionFormReset(pdfDocument);
    }

    public int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Flags);
    }

    public void setFlags(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Flags, value);
    }

    public PDFValueContainer<PDFValueContainer.Type, Object> getFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray array = this.getDictionaryArrayValue(ASName.k_Fields);
        if (array != null && !array.isEmpty()) {
            PDFValueContainer<PDFValueContainer.Type, Object> valueContainer = null;
            CosObject element = array.get(0);
            int count = array.size();
            if (element.getType() == 4) {
                String[] names = null;
                names = new String[count];
                for (int i = 0; i < count; ++i) {
                    names[i] = array.getText(i);
                }
                valueContainer = new PDFValueContainer<PDFValueContainer.Type, String[]>(PDFValueContainer.Type.StringArray, names);
            } else if (element.getType() == 6) {
                PDFFieldList fieldList = PDFFieldList.newInstance(this.getPDFDocument());
                for (int i = 0; i < count; ++i) {
                    fieldList.add(PDFFieldNode.getInstance(array.getCosDictionary(i)));
                }
                valueContainer = new PDFValueContainer<PDFValueContainer.Type, PDFFieldList>(PDFValueContainer.Type.FieldList, fieldList);
            }
            return valueContainer;
        }
        return null;
    }

    public void setFields(PDFFieldList array) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Fields, array);
    }

    public void setFields(String[] fieldNames) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (fieldNames != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            int addAtIndex = 0;
            for (int i = 0; i < fieldNames.length; ++i) {
                if (fieldNames[i] == null) continue;
                cosArray.addText(addAtIndex++, fieldNames[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_Fields, cosArray);
    }
}

