/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormImportData;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormReset;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormSubmit;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo3DView;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToEmbedded;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionHide;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionLaunch;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionMovie;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNoOp;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionRendition;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionSetOCGState;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionSetState;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionSound;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionThread;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionTransition;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionURI;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionUnknown;

public class PDFActionFactory {
    public static PDFAction getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosObject == null) {
            return null;
        }
        if (cosObject.getType() == 0) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("cosObject is not an itnstance of CosDictionary which was expected. Object Number =" + cosObject.getObjNum());
        }
        CosDictionary cosDict = (CosDictionary)cosObject;
        if (cosDict.containsKey(ASName.k_S)) {
            ASName subtype = cosDict.getName(ASName.k_S);
            if (subtype == ASName.k_GoTo) {
                return PDFActionGoTo.getInstance(cosObject);
            }
            if (subtype == ASName.k_GoToE) {
                return PDFActionGoToEmbedded.getInstance(cosObject);
            }
            if (subtype == ASName.k_GoToR) {
                return PDFActionGoToRemote.getInstance(cosObject);
            }
            if (subtype == ASName.k_Launch) {
                return PDFActionLaunch.getInstance(cosObject);
            }
            if (subtype == ASName.k_Thread) {
                return PDFActionThread.getInstance(cosObject);
            }
            if (subtype == ASName.k_URI) {
                return PDFActionURI.getInstance(cosObject);
            }
            if (subtype == ASName.k_Sound) {
                return PDFActionSound.getInstance(cosObject);
            }
            if (subtype == ASName.k_Movie) {
                return PDFActionMovie.getInstance(cosObject);
            }
            if (subtype == ASName.k_Hide) {
                return PDFActionHide.getInstance(cosObject);
            }
            if (subtype == ASName.k_Named) {
                return PDFActionNamed.getInstance(cosObject);
            }
            if (subtype == ASName.k_SetOCGState) {
                return PDFActionSetOCGState.getInstance(cosObject);
            }
            if (subtype == ASName.k_Rendition) {
                return PDFActionRendition.getInstance(cosObject);
            }
            if (subtype == ASName.k_Trans) {
                return PDFActionTransition.getInstance(cosObject);
            }
            if (subtype == ASName.k_GoTo3DView) {
                return PDFActionGoTo3DView.getInstance(cosObject);
            }
            if (subtype == ASName.create("set-state")) {
                return PDFActionSetState.getInstance(cosObject);
            }
            if (subtype == ASName.create("no-op")) {
                return PDFActionNoOp.getInstance(cosObject);
            }
            if (subtype == ASName.k_SubmitForm) {
                return PDFActionFormSubmit.getInstance(cosObject);
            }
            if (subtype == ASName.k_ResetForm) {
                return PDFActionFormReset.getInstance(cosObject);
            }
            if (subtype == ASName.k_ImportData) {
                return PDFActionFormImportData.getInstance(cosObject);
            }
            if (subtype == ASName.k_JavaScript) {
                return PDFActionJavaScript.getInstance(cosObject);
            }
        }
        return PDFActionUnknown.getInstance(cosObject);
    }
}

