/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;

public class PDFXObjectImageWithLocation {
    private ASMatrix matrix;
    private PDFRectangle location;
    private PDFXObjectImage xImage;
    private final PDFDocument document;

    public PDFXObjectImageWithLocation(PDFDocument doc, PDFXObjectImage image, ASMatrix xmatrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.xImage = image;
        this.matrix = xmatrix;
        this.document = doc;
        this.createImageLocation();
    }

    public ASMatrix getMatrix() {
        return this.matrix;
    }

    void setMatrix(ASMatrix matrix) {
        this.matrix = matrix;
    }

    public PDFXObjectImage getXImage() {
        return this.xImage;
    }

    public void setXImage(PDFXObjectImage image) {
        this.xImage = image;
    }

    public PDFRectangle getLocation() {
        return this.location;
    }

    public void setLocation(PDFRectangle location) {
        this.location = location;
    }

    public void createImageLocation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle rect = new ASRectangle(0.0, 0.0, 1.0, 1.0);
        ASRectangle imageRect = rect.transform(this.matrix);
        PDFRectangle locRect = PDFRectangle.newInstance(this.document, imageRect);
        this.setLocation(locRect);
    }
}

