/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFReference;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMeasure;
import com.adobe.internal.pdftoolkit.pdf.interactive.geospatial.PDFPointData;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOPIVersion;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;
import java.io.IOException;
import java.io.InputStream;

public class PDFXObjectForm
extends PDFXObject {
    private PDFXObjectForm(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDFXObjectForm getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFXObjectForm pdfObject = (PDFXObjectForm)PDFCosObject.getCachedInstance(cosObject, PDFXObjectForm.class);
        if (pdfObject == null) {
            pdfObject = new PDFXObjectForm(cosObject);
        }
        return pdfObject;
    }

    public static PDFXObjectForm newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        PDFXObjectForm xObjForm = new PDFXObjectForm(cosObject);
        xObjForm.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Form);
        xObjForm.setDictionaryNameValue(ASName.k_Type, ASName.k_XObject);
        xObjForm.addFlateFilter();
        return xObjForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDFXObjectForm newInstance(PDFDocument pdfDocument, PDFRectangle bbox, PDFResources pdfResources, InputByteStream contents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectForm pdfXObjectForm = PDFXObjectForm.newInstance(pdfDocument);
        InputStream is = null;
        try {
            try {
                if (contents != null) {
                    is = contents.toInputStream();
                    pdfXObjectForm.setStreamData(is);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        pdfXObjectForm.setBBox(bbox);
        pdfXObjectForm.setResources(pdfResources);
        pdfXObjectForm.addFlateFilter();
        return pdfXObjectForm;
    }

    public int getFormType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_FormType);
    }

    public void setFormType(int formType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_FormType, formType);
    }

    public ASName getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Name);
    }

    public void setName(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Name, name);
    }

    public ASDate getLastModified() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_LastModified);
    }

    public void setLastModified(ASDate date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (date == null) {
            this.removeValue(ASName.k_LastModified);
        } else {
            this.setDictionaryStringValue(ASName.k_LastModified, date.asString());
        }
    }

    public PDFRectangle getBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_BBox);
        return PDFRectangle.getInstance(cosArray);
    }

    public void setBBox(PDFRectangle rectangle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosCloneMgr mgr = new CosCloneMgr(this.getPDFDocument().getCosDocument());
        if (rectangle == null) {
            this.removeValue(ASName.k_BBox);
        } else {
            this.setDictionaryArrayValue(ASName.k_BBox, (CosArray)mgr.clone(rectangle.getCosArray()));
        }
    }

    public double[] getMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] matrix = null;
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Matrix);
        matrix = cosArray != null ? cosArray.getArrayDouble() : ASMatrix.createIdentityMatrix().getValues();
        return matrix;
    }

    public void setMatrix(double[] matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (matrix != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < 6; ++i) {
                cosArray.addDouble(i, matrix[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_Matrix, cosArray);
    }

    public PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_Resources));
    }

    public void setResources(PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Resources, resources);
    }

    public boolean isGroupXObject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Group);
    }

    public PDFGroupAttributes getGroup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFGroupAttributes.getInstance(this.getDictionaryCosObjectValue(ASName.k_Group));
    }

    public void setGroupAttributes(PDFGroupAttributes groupAttributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Group, groupAttributes);
    }

    public boolean isReferenceXObject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Ref);
    }

    public PDFReference getReference() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFReference.getInstance(this.getDictionaryCosObjectValue(ASName.k_Ref));
    }

    public void setReference(PDFReference reference) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Ref, reference);
    }

    @Override
    public PDFMetadata getMetadata() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMetadata.getInstance(this.getDictionaryCosObjectValue(ASName.k_Metadata));
    }

    @Override
    public void setMetadata(PDFMetadata metadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Metadata, metadata);
    }

    public PDFPagePiece getPieceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPagePiece.getInstance(this.getDictionaryCosObjectValue(ASName.k_PieceInfo));
    }

    public PDFPagePiece procurePieceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece pieceInfo = this.getPieceInfo();
        if (pieceInfo == null) {
            pieceInfo = PDFPagePiece.newInstance(this.getPDFDocument());
            this.setPieceInfo(pieceInfo);
        }
        return pieceInfo;
    }

    public void setPieceInfo(PDFPagePiece pieceInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PieceInfo, pieceInfo);
    }

    public boolean hasOPIVersion() {
        return this.getCosDictionary().containsKey(ASName.k_OPI);
    }

    public PDFOPIVersion getOPIVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOPIVersion.getInstance(this.getDictionaryCosObjectValue(ASName.k_OPI));
    }

    public void setOPIVersion(PDFOPIVersion opiVersion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_OPI, opiVersion);
    }

    public PDFOCObject getOCObject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOCObject.getInstance(this.getDictionaryCosObjectValue(ASName.k_OC));
    }

    public void setStream(InputByteStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosStream().newDataDecoded(stream);
    }

    public PDFContents getContents() {
        try {
            return PDFContents.getInstance(this.getCosObject());
        }
        catch (PDFInvalidDocumentException e) {
            return null;
        }
    }

    public void setContents(PDFContents pdfContents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfContents == null) {
            throw new PDFInvalidDocumentException("Invalid Parameter: pdfContents is null");
        }
        InputByteStream contents = pdfContents.getContents();
        try {
            if (contents != null) {
                this.setStreamData(contents.toInputStream());
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getMarkStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_MarkStyle);
    }

    public void setMarkStyle(String style) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryTextValue(ASName.k_MarkStyle, PDFText.createString(this.getPDFDocument(), style));
    }

    public ASName getPCM() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_PCM);
    }

    public void setMeasure(PDFMeasure value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Measure, value);
    }

    public boolean hasMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Measure);
    }

    public PDFMeasure getMeasure() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMeasure.getInstance(this.getDictionaryCosObjectValue(ASName.k_Measure));
    }

    public PDFPointData getPointData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPointData.getInstance(this.getDictionaryCosObjectValue(ASName.k_PtData));
    }

    public void setPointData(PDFPointData pdfPointData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_PtData, pdfPointData);
    }
}

