/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.shading;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingAxial;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingCoons;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingFreeForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingLattice;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingRadial;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingTensor;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingType;

public class PDFShadingFactory {
    public static PDFShading getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (cosObject == null) {
            throw new PDFInvalidParameterException("COS object is null");
        }
        if (cosObject.getType() == 0) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected");
        }
        if (!((CosDictionary)cosObject).containsKey(ASName.k_ShadingType)) {
            throw new PDFInvalidDocumentException("Unknown type.");
        }
        int subtype = ((CosDictionary)cosObject).getInt(ASName.k_ShadingType);
        PDFShadingType shadingType = PDFShadingType.getInstance(subtype);
        switch (shadingType) {
            case SHADING_TYPE_FUNCTION: {
                return PDFShadingFunction.getInstance(cosObject);
            }
            case SHADING_TYPE_AXIAL: {
                return PDFShadingAxial.getInstance(cosObject);
            }
            case SHADING_TYPE_RADIAL: {
                return PDFShadingRadial.getInstance(cosObject);
            }
            case SHADING_TYPE_FREEFORM: {
                return PDFShadingFreeForm.getInstance(cosObject);
            }
            case SHADING_TYPE_LATTICE: {
                return PDFShadingLattice.getInstance(cosObject);
            }
            case SHADING_TYPE_COONS: {
                return PDFShadingCoons.getInstance(cosObject);
            }
            case SHADING_TYPE_TENSOR: {
                return PDFShadingTensor.getInstance(cosObject);
            }
        }
        throw new PDFInvalidDocumentException("Bad Shading");
    }
}

