/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.impl;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.color.ColorSpace;
import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCalGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCalRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceLab;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpacePattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.FunctionCacheImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFColorSpaceWithTintTransform;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.util.Map;

public class ColorSpaceCacheImpl
implements ColorSpaceCache {
    private PDFColorSpace cs = null;
    private FunctionCacheImpl tintTransform = null;
    private ColorSpaceCacheImpl altCS = null;
    private double[] range = null;
    private ICC_ColorSpace iccColorSpace = null;
    private int numberOfComponents = -1;
    private byte[] indexedCSColorTable = null;
    private int indexedCSHighValue;
    private ColorModelWrapper colorModel = null;
    private boolean forceAlternateColorSpace;
    private Map<String, ColorSpaceCacheImpl> loadedColorSpaces = null;

    private ColorSpaceCacheImpl(PDFColorSpace cs, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, double[] range) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cs == null) {
            throw new PDFRuntimeException("Color space cann't be null while caching the color space entries.");
        }
        this.cs = cs;
        this.range = range;
        this.loadedColorSpaces = loadedColorSpaces;
        if (cs.getName() != ASName.k_Pattern) {
            this.numberOfComponents = cs.getNumberOfComponents();
        }
        PDFColorSpace pdfAltCS = null;
        if (cs.getName() == ASName.k_Separation || cs.getName() == ASName.k_DeviceN) {
            this.tintTransform = new FunctionCacheImpl(((PDFColorSpaceWithTintTransform)cs).getTintTransform());
            pdfAltCS = ((PDFColorSpaceWithTintTransform)cs).getAlternateColorSpace();
        } else if (cs.getName() == ASName.k_ICCBased) {
            pdfAltCS = ((PDFColorSpaceICCBased)cs).getAlternateColorSpace();
        } else if (cs.getName() == ASName.k_DeviceCMYK) {
            this.iccColorSpace = (ICC_ColorSpace)((PDFColorSpaceDeviceCMYK)cs).createColorSpace();
        } else if (cs.getName() == ASName.k_Indexed) {
            pdfAltCS = ((PDFColorSpaceIndexed)cs).getBaseColorSpace();
            this.indexedCSHighValue = ((PDFColorSpaceIndexed)cs).getHighValue();
            this.indexedCSColorTable = ((PDFColorSpaceIndexed)cs).getLookupData();
            int expectedLength = (this.indexedCSHighValue + 1) * this.getNumberOfComponents();
            if (this.indexedCSColorTable.length < expectedLength) {
                byte[] lookUpData = new byte[expectedLength];
                System.arraycopy(this.indexedCSColorTable, 0, lookUpData, 0, this.indexedCSColorTable.length);
                this.indexedCSColorTable = lookUpData;
            }
        } else if (cs.getName() == ASName.k_Pattern) {
            pdfAltCS = ((PDFColorSpacePattern)cs).getPatternColorSpace();
        }
        if (pdfAltCS != null) {
            this.altCS = ColorSpaceCacheImpl.newInstance(pdfAltCS, loadedColorSpaces, pdfAltCS.getName());
        }
    }

    public static ColorSpaceCacheImpl newInstance(PDFColorSpace cs, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, ASName csName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceCacheImpl.newInstance(cs, loadedColorSpaces, csName, null);
    }

    public static ColorSpaceCacheImpl newInstance(PDFColorSpace cs, Map<String, ColorSpaceCacheImpl> loadedColorSpaces, ASName csName, double[] range) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ColorSpaceCacheImpl csImpl = null;
        String key = GraphicsUtils.generateKey(cs != null ? cs.getCosObject().getObjNum() : 0, csName, null);
        if (key != null && loadedColorSpaces != null && (csImpl = loadedColorSpaces.get(key)) != null) {
            return csImpl;
        }
        csImpl = new ColorSpaceCacheImpl(cs, loadedColorSpaces, range);
        if (key != null && loadedColorSpaces != null) {
            loadedColorSpaces.put(key, csImpl);
        }
        return csImpl;
    }

    private ColorSpaceCacheImpl createAlternateColorSpace() throws PDFInvalidDocumentException {
        switch (this.numberOfComponents) {
            case 1: {
                return this.loadedColorSpaces.get(GraphicsUtils.DeviceGray);
            }
            case 3: {
                return this.loadedColorSpaces.get(GraphicsUtils.DeviceRGB);
            }
            case 4: {
                return this.loadedColorSpaces.get(GraphicsUtils.DeviceCMYK);
            }
        }
        return null;
    }

    @Override
    public double[] toRGB(double[] inputColorValues) {
        try {
            if (inputColorValues == null) {
                inputColorValues = this.cs.getDefaultColor();
            }
            if (this.forceAlternateColorSpace && this.getSubstituteColorSpace() != null) {
                return this.getSubstituteColorSpace().toRGB(inputColorValues);
            }
            if (this.cs.getName() == ASName.k_Separation || this.cs.getName() == ASName.k_DeviceN) {
                return ColorManager.colorSpaceWithTintTransformToRGB(inputColorValues, this.tintTransform, this.altCS);
            }
            if (this.cs.getName() == ASName.k_ICCBased) {
                try {
                    if (this.iccColorSpace == null) {
                        this.iccColorSpace = (ICC_ColorSpace)this.cs.createColorSpace();
                    }
                    return ColorManager.convertICCToDeviceRGB(inputColorValues, this.iccColorSpace);
                }
                catch (Exception e) {
                    this.forceAlternateColorSpace = true;
                    ColorSpaceCache altCS = this.getSubstituteColorSpace();
                    if (altCS != null) {
                        return altCS.toRGB(inputColorValues);
                    }
                }
            } else {
                if (this.cs.getName() == ASName.k_DeviceCMYK) {
                    return ColorManager.convertICCToDeviceRGB(inputColorValues, this.iccColorSpace);
                }
                if (this.cs.getName() == ASName.k_Indexed) {
                    return ColorManager.indexedToRGB(inputColorValues, this.indexedCSColorTable, this.indexedCSHighValue, this.altCS, this.altCS.getRange(), this.altCS.getNumberOfComponents());
                }
                if (this.cs.getName() == ASName.k_Lab) {
                    return ColorManager.convertLabToRGB(inputColorValues, ((PDFColorSpaceLab)this.cs).getWhitePoint());
                }
                if (this.cs.getName() == ASName.k_CalRGB) {
                    return ColorManager.calRGBToRGB(inputColorValues, ((PDFColorSpaceCalRGB)this.cs).getMatrix(), ((PDFColorSpaceCalRGB)this.cs).getGamma());
                }
                if (this.cs.getName() == ASName.k_CalGray) {
                    return ColorManager.calGrayToRGB(inputColorValues, ((PDFColorSpaceCalGray)this.cs).getWhitePoint(), ((PDFColorSpaceCalGray)this.cs).getGamma());
                }
                if (this.cs.getName() == ASName.k_DeviceGray) {
                    return ColorManager.convertDeviceGrayToDeviceRGB(inputColorValues[0]);
                }
                if (this.cs.getName() == ASName.k_DeviceRGB) {
                    return inputColorValues;
                }
                if (this.cs.getName() == ASName.k_Pattern && this.altCS != null) {
                    return this.altCS.toRGB(inputColorValues);
                }
            }
        }
        catch (PDFCosParseException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        return null;
    }

    @Override
    public int getHighValue() {
        return this.indexedCSHighValue;
    }

    @Override
    public byte[] getLookupData() {
        return this.indexedCSColorTable;
    }

    @Override
    public double[] applyTintTransform(double[] input) {
        return this.tintTransform.apply(input);
    }

    @Override
    public ColorSpaceCache getSubstituteColorSpace() {
        try {
            if (this.altCS == null && this.cs.getName() == ASName.k_ICCBased) {
                this.altCS = this.createAlternateColorSpace();
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        return this.altCS;
    }

    @Override
    public double[] getRange() {
        if (this.range == null) {
            this.range = this.cs.getRange();
        }
        return this.range;
    }

    @Override
    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    @Override
    public ColorSpace getUnderlyingColorspace() {
        return this.cs;
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        if (this.colorModel == null || this.colorModel.bpc != bpc || this.colorModel.transferType != transferType) {
            this.colorModel = new ColorModelWrapper(bpc, transferType, this.cs.createColorModel(bpc, transferType));
        }
        return this.colorModel.cm;
    }

    private static class ColorModelWrapper {
        private int bpc;
        private int transferType;
        private ColorModel cm;

        private ColorModelWrapper(int bpc, int transferType, ColorModel cm) {
            this.bpc = bpc;
            this.transferType = transferType;
            this.cm = cm;
        }
    }
}

