/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.impl.CoreFontUtils;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.Encoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardCharSetEncodings;
import java.util.HashMap;
import java.util.Map;

public final class StandardFontUtils
extends CoreFontUtils {
    private static final Font[] mBase14Fonts = new Font[]{Base14.courierBold, Base14.courierBoldOblique, Base14.courierOblique, Base14.courierRegular, Base14.helveticaBold, Base14.helveticaBoldOblique, Base14.helveticaOblique, Base14.helveticaRegular, Base14.symbol, Base14.timesBold, Base14.timesBoldItalic, Base14.timesItalic, Base14.timesRegular, Base14.zapfDingbats};
    private static final Map<String, Font> base14FontsMap = new HashMap<String, Font>();
    public static final int STANDARD_FONT_FIRST_CHAR = 0;
    public static final int STANDARD_FONT_LAST_CHAR = 255;
    private static final int[] widthsCourier;
    private static final int[] widthsCourierOblique;
    private static final int[] widthsCourierBold;
    private static final int[] widthsCourierBoldOblique;
    private static final int[] widthsHelvetica;
    private static final int[] widthsHelveticaOblique;
    private static final int[] widthsHelveticaBold;
    private static final int[] widthsHelveticaBoldOblique;
    private static final int[] widthsTimesRoman;
    private static final int[] widthsTimesItalic;
    private static final int[] widthsTimesBold;
    private static final int[] widthsTimesBoldItalic;
    private static final int[] widthsSymbol;
    private static final int[] widthsZapfDingbats;
    private static final HashMap<ASName, int[]> standardFontsWidths;
    private static final HashMap<Integer, Integer> unicodeToWidthsTableIndex;

    private StandardFontUtils() {
    }

    public static Font getBase14Font(String fontName, boolean useProperName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName properBase14Name;
        ASName aSName = properBase14Name = useProperName ? StandardFontUtils.getStandardFontProperName(ASName.create(fontName)) : ASName.create(fontName);
        if (properBase14Name != null) {
            return base14FontsMap.get(properBase14Name.asString());
        }
        return null;
    }

    public static Font[] getBase14Fonts() {
        return mBase14Fonts;
    }

    public static ASName getStandardFontProperName(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (ASName)standardFontsNames.get(fontName);
    }

    public static int[] getStandardFontWidths(PDFFontSimple font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName properFontName = StandardFontUtils.getStandardFontProperName(font.getBaseFont());
        int[] widths = standardFontsWidths.get(properFontName);
        if (widths.length == 1 || properFontName == ASName.k_Symbol || properFontName == ASName.k_ZapfDingbats) {
            return widths;
        }
        PDFSimpleFontEncoding pdfSimpleFontEncoding = font.getEncoding();
        Encoding encoding = pdfSimpleFontEncoding;
        if (encoding == null) {
            try {
                encoding = StandardCharSetEncodings.get(ASName.k_StandardEncoding);
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException("Could not get a pre-defined character set encoding.", e);
            }
        }
        int[] encodedWidths = new int[256];
        for (int i = 0; i < 256; ++i) {
            char[] uniChars = encoding.toUnicode((byte)i, properFontName);
            char unicode = uniChars[0];
            int width = 0;
            if (unicode != '\ufffd') {
                Integer widthsTableIndex = unicodeToWidthsTableIndex.get(unicode);
                if (widthsTableIndex == null && (unicode == '\u00a0' && pdfSimpleFontEncoding.isWinAnsiEncoding() || unicode == '\u00ca' && pdfSimpleFontEncoding.isMacRomanEncoding())) {
                    widthsTableIndex = unicodeToWidthsTableIndex.get(32);
                }
                if (widthsTableIndex != null) {
                    width = widths[widthsTableIndex];
                }
            }
            encodedWidths[i] = width;
        }
        return encodedWidths;
    }

    static {
        for (Font font : mBase14Fonts) {
            try {
                base14FontsMap.put(font.getPDFFontDescription().getBase14Name(), font);
            }
            catch (InvalidFontException invalidFontException) {
            }
            catch (UnsupportedFontException unsupportedFontException) {
            }
            catch (FontLoadingException fontLoadingException) {
                // empty catch block
            }
        }
        widthsCourier = new int[]{600};
        widthsCourierOblique = new int[]{600};
        widthsCourierBold = new int[]{600};
        widthsCourierBoldOblique = new int[]{600};
        widthsHelvetica = new int[]{667, 1000, 667, 667, 667, 667, 667, 667, 667, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 500, 667, 556, 0, 556, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 667, 556, 0, 0, 0, 0, 0, 469, 584, 389, 1015, 556, 556, 278, 260, 334, 334, 278, 278, 333, 260, 350, 500, 333, 500, 333, 556, 0, 333, 278, 278, 737, 556, 556, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 556, 278, 333, 278, 500, 556, 500, 556, 0, 556, 167, 556, 0, 611, 333, 0, 584, 556, 556, 333, 333, 556, 333, 333, 222, 278, 278, 278, 278, 0, 0, 222, 500, 222, 0, 0, 584, 0, 0, 584, 222, 833, 333, 0, 584, 556, 584, 556, 556, 0, 556, 556, 556, 556, 556, 556, 944, 333, 556, 556, 834, 834, 333, 370, 365, 611, 556, 0, 556, 537, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 556, 556, 611, 355, 333, 333, 333, 222, 222, 222, 191, 333, 737, 0, 333, 500, 500, 0, 556, 278, 556, 556, 278, 278, 0, 556, 0, 278, 0, 556, 556, 834, 333, 333, 1000, 556, 333, 556, 556, 556, 556, 556, 556, 0, 500, 722, 500, 500, 500, 500, 556, 500, 500, 556};
        widthsHelveticaOblique = new int[]{667, 1000, 667, 667, 667, 667, 667, 667, 667, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 500, 667, 556, 0, 556, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 667, 556, 0, 0, 0, 0, 0, 469, 584, 389, 1015, 556, 556, 278, 260, 334, 334, 278, 278, 333, 260, 350, 500, 333, 500, 333, 556, 0, 333, 278, 278, 737, 556, 556, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 556, 278, 333, 278, 500, 556, 500, 556, 0, 556, 167, 556, 0, 611, 333, 0, 584, 556, 556, 333, 333, 556, 333, 333, 222, 278, 278, 278, 278, 0, 0, 222, 500, 222, 0, 0, 584, 0, 0, 584, 222, 833, 333, 0, 584, 556, 584, 556, 556, 0, 556, 556, 556, 556, 556, 556, 944, 333, 556, 556, 834, 834, 333, 370, 365, 611, 556, 0, 556, 537, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 556, 556, 611, 355, 333, 333, 333, 222, 222, 222, 191, 333, 737, 0, 333, 500, 500, 0, 556, 278, 556, 556, 278, 278, 0, 556, 0, 278, 0, 556, 556, 834, 333, 333, 1000, 556, 333, 556, 556, 556, 556, 556, 556, 0, 500, 722, 500, 500, 500, 500, 556, 500, 500, 556};
        widthsHelveticaBold = new int[]{722, 1000, 722, 722, 722, 722, 722, 722, 722, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 556, 722, 611, 0, 611, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 722, 556, 0, 0, 0, 0, 0, 584, 584, 389, 975, 556, 611, 278, 280, 389, 389, 333, 333, 333, 280, 350, 556, 333, 556, 333, 556, 0, 333, 333, 278, 737, 556, 611, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 611, 333, 333, 333, 611, 556, 611, 556, 0, 556, 167, 611, 0, 611, 333, 0, 584, 556, 556, 333, 333, 611, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 556, 278, 0, 0, 584, 0, 0, 584, 278, 889, 333, 0, 584, 611, 584, 611, 556, 0, 611, 556, 611, 611, 611, 611, 944, 333, 611, 556, 834, 834, 333, 370, 365, 611, 611, 0, 611, 556, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 611, 611, 611, 474, 500, 500, 500, 278, 278, 278, 238, 389, 737, 0, 333, 556, 556, 0, 556, 333, 556, 556, 278, 278, 0, 556, 0, 333, 0, 611, 556, 834, 333, 333, 1000, 556, 333, 611, 611, 611, 611, 611, 556, 0, 556, 778, 556, 556, 556, 556, 556, 500, 500, 556};
        widthsHelveticaBoldOblique = new int[]{722, 1000, 722, 722, 722, 722, 722, 722, 722, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 556, 722, 611, 0, 611, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 722, 556, 0, 0, 0, 0, 0, 584, 584, 389, 975, 556, 611, 278, 280, 389, 389, 333, 333, 333, 280, 350, 556, 333, 556, 333, 556, 0, 333, 333, 278, 737, 556, 611, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 611, 333, 333, 333, 611, 556, 611, 556, 0, 556, 167, 611, 0, 611, 333, 0, 584, 556, 556, 333, 333, 611, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 556, 278, 0, 0, 584, 0, 0, 584, 278, 889, 333, 0, 584, 611, 584, 611, 556, 0, 611, 556, 611, 611, 611, 611, 944, 333, 611, 556, 834, 834, 333, 370, 365, 611, 611, 0, 611, 556, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 611, 611, 611, 474, 500, 500, 500, 278, 278, 278, 238, 389, 737, 0, 333, 556, 556, 0, 556, 333, 556, 556, 278, 278, 0, 556, 0, 333, 0, 611, 556, 834, 333, 333, 1000, 556, 333, 611, 611, 611, 611, 611, 556, 0, 556, 778, 556, 556, 556, 556, 556, 500, 500, 556};
        widthsTimesRoman = new int[]{722, 889, 722, 722, 722, 722, 722, 722, 667, 667, 667, 722, 611, 611, 611, 611, 611, 722, 556, 722, 0, 722, 333, 0, 333, 333, 333, 0, 333, 389, 722, 611, 0, 611, 889, 722, 722, 722, 889, 722, 722, 722, 722, 722, 722, 556, 722, 667, 556, 556, 0, 611, 556, 722, 722, 722, 722, 722, 722, 944, 722, 722, 722, 722, 611, 611, 444, 444, 444, 333, 444, 667, 444, 778, 444, 0, 0, 0, 0, 0, 469, 541, 500, 921, 444, 500, 278, 200, 480, 480, 333, 333, 333, 200, 350, 444, 333, 444, 333, 500, 0, 333, 278, 250, 760, 500, 500, 500, 500, 0, 400, 333, 564, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 1000, 1000, 500, 564, 500, 333, 333, 333, 556, 500, 556, 500, 0, 500, 167, 500, 0, 500, 333, 0, 564, 500, 500, 333, 333, 500, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 500, 278, 0, 0, 564, 0, 0, 564, 278, 778, 333, 0, 564, 500, 564, 500, 500, 0, 500, 500, 500, 500, 500, 500, 722, 333, 500, 500, 750, 750, 300, 276, 310, 500, 500, 0, 500, 453, 333, 333, 833, 250, 250, 1000, 564, 564, 0, 500, 444, 444, 408, 444, 444, 444, 333, 333, 333, 180, 333, 760, 0, 333, 389, 389, 0, 500, 278, 500, 500, 278, 250, 0, 500, 0, 278, 0, 500, 500, 750, 300, 333, 980, 500, 300, 500, 500, 500, 500, 500, 500, 0, 500, 722, 500, 500, 500, 500, 500, 444, 444, 500};
        widthsTimesItalic = new int[]{611, 889, 611, 611, 611, 611, 611, 611, 611, 667, 667, 722, 611, 611, 611, 611, 611, 722, 611, 722, 0, 722, 333, 0, 333, 333, 333, 0, 333, 444, 667, 556, 0, 556, 833, 667, 667, 722, 944, 722, 722, 722, 722, 722, 722, 611, 722, 611, 500, 500, 0, 556, 611, 722, 722, 722, 722, 722, 611, 833, 611, 556, 556, 556, 556, 556, 500, 500, 500, 333, 500, 667, 500, 778, 500, 0, 0, 0, 0, 0, 422, 541, 500, 920, 500, 500, 278, 275, 400, 400, 389, 389, 333, 275, 350, 444, 333, 444, 333, 500, 0, 333, 333, 250, 760, 500, 500, 500, 500, 0, 400, 333, 675, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 889, 889, 500, 675, 500, 333, 389, 278, 500, 500, 500, 500, 0, 500, 167, 500, 0, 500, 333, 0, 675, 500, 500, 333, 333, 500, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 444, 278, 0, 0, 675, 0, 0, 675, 278, 722, 333, 0, 675, 500, 675, 500, 500, 0, 500, 500, 500, 500, 500, 500, 667, 333, 500, 500, 750, 750, 300, 276, 310, 500, 500, 0, 500, 523, 333, 333, 833, 250, 250, 1000, 675, 675, 0, 500, 500, 500, 420, 556, 556, 556, 333, 333, 333, 214, 389, 760, 0, 333, 389, 389, 0, 500, 333, 500, 500, 278, 250, 0, 500, 0, 278, 0, 500, 500, 750, 300, 333, 980, 500, 300, 500, 500, 500, 500, 500, 500, 0, 444, 667, 444, 444, 444, 444, 500, 389, 389, 500};
        widthsTimesBold = new int[]{722, 1000, 722, 722, 722, 722, 722, 722, 667, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 778, 389, 0, 389, 389, 389, 0, 389, 500, 778, 667, 0, 667, 944, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 611, 778, 722, 556, 556, 0, 667, 611, 722, 722, 722, 722, 722, 722, 1000, 722, 722, 722, 722, 667, 667, 500, 500, 500, 333, 500, 722, 500, 833, 500, 0, 0, 0, 0, 0, 581, 520, 500, 930, 500, 556, 278, 220, 394, 394, 333, 333, 333, 220, 350, 444, 333, 444, 333, 500, 0, 333, 333, 250, 747, 500, 556, 500, 500, 0, 400, 333, 570, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 1000, 1000, 500, 570, 500, 333, 333, 333, 556, 500, 556, 500, 0, 500, 167, 500, 0, 556, 333, 0, 570, 500, 500, 333, 333, 556, 333, 333, 278, 278, 278, 278, 278, 0, 0, 333, 556, 278, 0, 0, 570, 0, 0, 570, 278, 833, 333, 0, 570, 556, 570, 556, 500, 0, 556, 500, 500, 500, 500, 500, 722, 333, 500, 500, 750, 750, 300, 300, 330, 500, 500, 0, 556, 540, 333, 333, 1000, 250, 250, 1000, 570, 570, 0, 556, 500, 500, 555, 500, 500, 500, 333, 333, 333, 278, 444, 747, 0, 333, 389, 389, 0, 500, 333, 500, 500, 278, 250, 0, 500, 0, 333, 0, 556, 500, 750, 300, 333, 1000, 500, 300, 556, 556, 556, 556, 556, 500, 0, 500, 722, 500, 500, 500, 500, 500, 444, 444, 500};
        widthsTimesBoldItalic = new int[]{667, 944, 667, 667, 667, 667, 667, 667, 667, 667, 667, 722, 667, 667, 667, 667, 667, 722, 667, 722, 0, 778, 389, 0, 389, 389, 389, 0, 389, 500, 667, 611, 0, 611, 889, 722, 722, 722, 944, 722, 722, 722, 722, 722, 722, 611, 722, 667, 556, 556, 0, 611, 611, 722, 722, 722, 722, 722, 667, 889, 667, 611, 611, 611, 611, 611, 500, 500, 500, 333, 500, 722, 500, 778, 500, 0, 0, 0, 0, 0, 570, 570, 500, 832, 500, 500, 278, 220, 348, 348, 333, 333, 333, 220, 350, 444, 333, 444, 333, 500, 0, 333, 333, 250, 747, 500, 500, 500, 500, 0, 400, 333, 570, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 1000, 1000, 500, 570, 500, 389, 389, 333, 556, 500, 556, 500, 0, 500, 167, 500, 0, 500, 333, 0, 570, 500, 500, 333, 333, 556, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 500, 278, 0, 0, 570, 0, 0, 606, 278, 778, 333, 0, 606, 576, 570, 556, 500, 0, 556, 500, 500, 500, 500, 500, 722, 333, 500, 500, 750, 750, 300, 266, 300, 500, 500, 0, 500, 500, 333, 333, 833, 250, 250, 1000, 570, 570, 0, 500, 500, 500, 555, 500, 500, 500, 333, 333, 333, 278, 389, 747, 0, 333, 389, 389, 0, 500, 333, 500, 500, 278, 250, 0, 500, 0, 278, 0, 500, 500, 750, 300, 333, 1000, 500, 300, 556, 556, 556, 556, 556, 500, 0, 444, 667, 500, 444, 444, 444, 500, 389, 389, 500};
        widthsSymbol = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250, 333, 713, 500, 549, 833, 778, 439, 333, 333, 500, 549, 250, 549, 250, 278, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 278, 278, 549, 549, 549, 444, 549, 722, 667, 722, 612, 611, 763, 603, 722, 333, 631, 722, 686, 889, 722, 722, 768, 741, 556, 592, 611, 690, 439, 768, 645, 795, 611, 333, 863, 333, 658, 500, 500, 631, 549, 549, 494, 439, 521, 411, 603, 329, 603, 549, 549, 576, 521, 549, 549, 521, 549, 603, 439, 576, 713, 686, 493, 686, 494, 480, 200, 480, 549, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 620, 247, 549, 167, 713, 500, 753, 753, 753, 753, 1042, 987, 603, 987, 603, 400, 549, 411, 549, 549, 713, 494, 460, 549, 549, 549, 549, 1000, 603, 1000, 658, 823, 686, 795, 987, 768, 768, 823, 768, 768, 713, 713, 713, 713, 713, 713, 713, 768, 713, 790, 790, 890, 823, 549, 250, 713, 603, 603, 1042, 987, 603, 987, 603, 494, 329, 790, 790, 786, 713, 384, 384, 384, 384, 384, 384, 494, 494, 494, 494, 0, 329, 274, 686, 686, 686, 384, 384, 384, 384, 384, 384, 494, 494, 494, 0, 790};
        widthsZapfDingbats = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 278, 974, 961, 974, 980, 719, 789, 790, 791, 690, 960, 939, 549, 855, 911, 933, 911, 945, 974, 755, 846, 762, 761, 571, 677, 763, 760, 759, 754, 494, 552, 537, 577, 692, 786, 788, 788, 790, 793, 794, 816, 823, 789, 841, 823, 833, 816, 831, 923, 744, 723, 749, 790, 792, 695, 776, 768, 792, 759, 707, 708, 682, 701, 826, 815, 789, 789, 707, 687, 696, 689, 786, 787, 713, 791, 785, 791, 873, 761, 762, 762, 759, 759, 892, 892, 788, 784, 438, 138, 277, 415, 392, 392, 668, 668, 0, 0, 0, 0, 790, 668, 537, 537, 668, 668, 537, 537, 537, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 732, 544, 544, 910, 667, 760, 760, 776, 595, 694, 626, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 894, 838, 1016, 458, 748, 924, 748, 918, 927, 928, 928, 834, 873, 828, 924, 924, 917, 930, 931, 463, 883, 836, 836, 867, 867, 696, 696, 874, 0, 874, 760, 946, 771, 865, 771, 888, 967, 888, 831, 873, 927, 970, 918, 0, 410, 509, 334, 509, 390, 234, 276, 390, 410, 317, 317, 276, 334, 234};
        standardFontsWidths = new HashMap(14, 0.5f);
        standardFontsWidths.put(ASName.k_Times_Roman, widthsTimesRoman);
        standardFontsWidths.put(ASName.k_Times_Bold, widthsTimesBold);
        standardFontsWidths.put(ASName.k_Times_Italic, widthsTimesItalic);
        standardFontsWidths.put(ASName.k_Times_BoldItalic, widthsTimesBoldItalic);
        standardFontsWidths.put(ASName.k_Helvetica, widthsHelvetica);
        standardFontsWidths.put(ASName.k_Helvetica_Bold, widthsHelveticaBold);
        standardFontsWidths.put(ASName.k_Helvetica_Oblique, widthsHelveticaOblique);
        standardFontsWidths.put(ASName.k_Helvetica_BoldOblique, widthsHelveticaBoldOblique);
        standardFontsWidths.put(ASName.k_Courier, widthsCourier);
        standardFontsWidths.put(ASName.k_Courier_Bold, widthsCourierBold);
        standardFontsWidths.put(ASName.k_Courier_Oblique, widthsCourierOblique);
        standardFontsWidths.put(ASName.k_Courier_BoldOblique, widthsCourierBoldOblique);
        standardFontsWidths.put(ASName.k_Symbol, widthsSymbol);
        standardFontsWidths.put(ASName.k_ZapfDingbats, widthsZapfDingbats);
        unicodeToWidthsTableIndex = new HashMap(160, 0.5f);
        unicodeToWidthsTableIndex.put(65, 0);
        unicodeToWidthsTableIndex.put(198, 1);
        unicodeToWidthsTableIndex.put(193, 2);
        unicodeToWidthsTableIndex.put(194, 3);
        unicodeToWidthsTableIndex.put(196, 4);
        unicodeToWidthsTableIndex.put(192, 5);
        unicodeToWidthsTableIndex.put(197, 6);
        unicodeToWidthsTableIndex.put(195, 7);
        unicodeToWidthsTableIndex.put(66, 8);
        unicodeToWidthsTableIndex.put(67, 9);
        unicodeToWidthsTableIndex.put(199, 10);
        unicodeToWidthsTableIndex.put(68, 11);
        unicodeToWidthsTableIndex.put(69, 12);
        unicodeToWidthsTableIndex.put(201, 13);
        unicodeToWidthsTableIndex.put(202, 14);
        unicodeToWidthsTableIndex.put(203, 15);
        unicodeToWidthsTableIndex.put(200, 16);
        unicodeToWidthsTableIndex.put(208, 17);
        unicodeToWidthsTableIndex.put(70, 18);
        unicodeToWidthsTableIndex.put(71, 19);
        unicodeToWidthsTableIndex.put(486, 20);
        unicodeToWidthsTableIndex.put(72, 21);
        unicodeToWidthsTableIndex.put(73, 22);
        unicodeToWidthsTableIndex.put(306, 23);
        unicodeToWidthsTableIndex.put(205, 24);
        unicodeToWidthsTableIndex.put(206, 25);
        unicodeToWidthsTableIndex.put(207, 26);
        unicodeToWidthsTableIndex.put(304, 27);
        unicodeToWidthsTableIndex.put(204, 28);
        unicodeToWidthsTableIndex.put(74, 29);
        unicodeToWidthsTableIndex.put(75, 30);
        unicodeToWidthsTableIndex.put(76, 31);
        unicodeToWidthsTableIndex.put(63167, 32);
        unicodeToWidthsTableIndex.put(321, 33);
        unicodeToWidthsTableIndex.put(77, 34);
        unicodeToWidthsTableIndex.put(78, 35);
        unicodeToWidthsTableIndex.put(209, 36);
        unicodeToWidthsTableIndex.put(79, 37);
        unicodeToWidthsTableIndex.put(338, 38);
        unicodeToWidthsTableIndex.put(211, 39);
        unicodeToWidthsTableIndex.put(212, 40);
        unicodeToWidthsTableIndex.put(214, 41);
        unicodeToWidthsTableIndex.put(210, 42);
        unicodeToWidthsTableIndex.put(216, 43);
        unicodeToWidthsTableIndex.put(213, 44);
        unicodeToWidthsTableIndex.put(80, 45);
        unicodeToWidthsTableIndex.put(81, 46);
        unicodeToWidthsTableIndex.put(82, 47);
        unicodeToWidthsTableIndex.put(83, 48);
        unicodeToWidthsTableIndex.put(352, 49);
        unicodeToWidthsTableIndex.put(350, 50);
        unicodeToWidthsTableIndex.put(84, 51);
        unicodeToWidthsTableIndex.put(222, 52);
        unicodeToWidthsTableIndex.put(85, 53);
        unicodeToWidthsTableIndex.put(218, 54);
        unicodeToWidthsTableIndex.put(219, 55);
        unicodeToWidthsTableIndex.put(220, 56);
        unicodeToWidthsTableIndex.put(217, 57);
        unicodeToWidthsTableIndex.put(86, 58);
        unicodeToWidthsTableIndex.put(87, 59);
        unicodeToWidthsTableIndex.put(88, 60);
        unicodeToWidthsTableIndex.put(89, 61);
        unicodeToWidthsTableIndex.put(221, 62);
        unicodeToWidthsTableIndex.put(376, 63);
        unicodeToWidthsTableIndex.put(90, 64);
        unicodeToWidthsTableIndex.put(381, 65);
        unicodeToWidthsTableIndex.put(97, 66);
        unicodeToWidthsTableIndex.put(225, 67);
        unicodeToWidthsTableIndex.put(226, 68);
        unicodeToWidthsTableIndex.put(180, 69);
        unicodeToWidthsTableIndex.put(228, 70);
        unicodeToWidthsTableIndex.put(230, 71);
        unicodeToWidthsTableIndex.put(224, 72);
        unicodeToWidthsTableIndex.put(38, 73);
        unicodeToWidthsTableIndex.put(229, 74);
        unicodeToWidthsTableIndex.put(8596, 75);
        unicodeToWidthsTableIndex.put(8595, 76);
        unicodeToWidthsTableIndex.put(8592, 77);
        unicodeToWidthsTableIndex.put(8594, 78);
        unicodeToWidthsTableIndex.put(8593, 79);
        unicodeToWidthsTableIndex.put(94, 80);
        unicodeToWidthsTableIndex.put(126, 81);
        unicodeToWidthsTableIndex.put(42, 82);
        unicodeToWidthsTableIndex.put(64, 83);
        unicodeToWidthsTableIndex.put(227, 84);
        unicodeToWidthsTableIndex.put(98, 85);
        unicodeToWidthsTableIndex.put(92, 86);
        unicodeToWidthsTableIndex.put(124, 87);
        unicodeToWidthsTableIndex.put(123, 88);
        unicodeToWidthsTableIndex.put(125, 89);
        unicodeToWidthsTableIndex.put(91, 90);
        unicodeToWidthsTableIndex.put(93, 91);
        unicodeToWidthsTableIndex.put(728, 92);
        unicodeToWidthsTableIndex.put(166, 93);
        unicodeToWidthsTableIndex.put(8226, 94);
        unicodeToWidthsTableIndex.put(99, 95);
        unicodeToWidthsTableIndex.put(711, 96);
        unicodeToWidthsTableIndex.put(231, 97);
        unicodeToWidthsTableIndex.put(184, 98);
        unicodeToWidthsTableIndex.put(162, 99);
        unicodeToWidthsTableIndex.put(65533, 100);
        unicodeToWidthsTableIndex.put(710, 101);
        unicodeToWidthsTableIndex.put(58, 102);
        unicodeToWidthsTableIndex.put(44, 103);
        unicodeToWidthsTableIndex.put(169, 104);
        unicodeToWidthsTableIndex.put(164, 105);
        unicodeToWidthsTableIndex.put(100, 106);
        unicodeToWidthsTableIndex.put(8224, 107);
        unicodeToWidthsTableIndex.put(8225, 108);
        unicodeToWidthsTableIndex.put(65533, 109);
        unicodeToWidthsTableIndex.put(176, 110);
        unicodeToWidthsTableIndex.put(168, 111);
        unicodeToWidthsTableIndex.put(247, 112);
        unicodeToWidthsTableIndex.put(36, 113);
        unicodeToWidthsTableIndex.put(729, 114);
        unicodeToWidthsTableIndex.put(305, 115);
        unicodeToWidthsTableIndex.put(65533, 116);
        unicodeToWidthsTableIndex.put(101, 117);
        unicodeToWidthsTableIndex.put(233, 118);
        unicodeToWidthsTableIndex.put(234, 119);
        unicodeToWidthsTableIndex.put(235, 120);
        unicodeToWidthsTableIndex.put(232, 121);
        unicodeToWidthsTableIndex.put(56, 122);
        unicodeToWidthsTableIndex.put(8230, 123);
        unicodeToWidthsTableIndex.put(8212, 124);
        unicodeToWidthsTableIndex.put(8211, 125);
        unicodeToWidthsTableIndex.put(61, 126);
        unicodeToWidthsTableIndex.put(240, 127);
        unicodeToWidthsTableIndex.put(33, 128);
        unicodeToWidthsTableIndex.put(161, 129);
        unicodeToWidthsTableIndex.put(102, 130);
        unicodeToWidthsTableIndex.put(64257, 131);
        unicodeToWidthsTableIndex.put(53, 132);
        unicodeToWidthsTableIndex.put(64258, 133);
        unicodeToWidthsTableIndex.put(402, 134);
        unicodeToWidthsTableIndex.put(65533, 135);
        unicodeToWidthsTableIndex.put(52, 136);
        unicodeToWidthsTableIndex.put(8260, 137);
        unicodeToWidthsTableIndex.put(103, 138);
        unicodeToWidthsTableIndex.put(487, 139);
        unicodeToWidthsTableIndex.put(223, 140);
        unicodeToWidthsTableIndex.put(96, 141);
        unicodeToWidthsTableIndex.put(65533, 142);
        unicodeToWidthsTableIndex.put(62, 143);
        unicodeToWidthsTableIndex.put(171, 144);
        unicodeToWidthsTableIndex.put(187, 145);
        unicodeToWidthsTableIndex.put(8249, 146);
        unicodeToWidthsTableIndex.put(8250, 147);
        unicodeToWidthsTableIndex.put(104, 148);
        unicodeToWidthsTableIndex.put(733, 149);
        unicodeToWidthsTableIndex.put(45, 150);
        unicodeToWidthsTableIndex.put(105, 151);
        unicodeToWidthsTableIndex.put(237, 152);
        unicodeToWidthsTableIndex.put(238, 153);
        unicodeToWidthsTableIndex.put(239, 154);
        unicodeToWidthsTableIndex.put(236, 155);
        unicodeToWidthsTableIndex.put(307, 156);
        unicodeToWidthsTableIndex.put(65533, 157);
        unicodeToWidthsTableIndex.put(106, 158);
        unicodeToWidthsTableIndex.put(107, 159);
        unicodeToWidthsTableIndex.put(108, 160);
        unicodeToWidthsTableIndex.put(65533, 161);
        unicodeToWidthsTableIndex.put(65533, 162);
        unicodeToWidthsTableIndex.put(60, 163);
        unicodeToWidthsTableIndex.put(8356, 164);
        unicodeToWidthsTableIndex.put(63168, 165);
        unicodeToWidthsTableIndex.put(172, 166);
        unicodeToWidthsTableIndex.put(322, 167);
        unicodeToWidthsTableIndex.put(109, 168);
        unicodeToWidthsTableIndex.put(175, 169);
        unicodeToWidthsTableIndex.put(65533, 170);
        unicodeToWidthsTableIndex.put(8722, 171);
        unicodeToWidthsTableIndex.put(181, 172);
        unicodeToWidthsTableIndex.put(215, 173);
        unicodeToWidthsTableIndex.put(110, 174);
        unicodeToWidthsTableIndex.put(57, 175);
        unicodeToWidthsTableIndex.put(65533, 176);
        unicodeToWidthsTableIndex.put(241, 177);
        unicodeToWidthsTableIndex.put(35, 178);
        unicodeToWidthsTableIndex.put(111, 179);
        unicodeToWidthsTableIndex.put(243, 180);
        unicodeToWidthsTableIndex.put(244, 181);
        unicodeToWidthsTableIndex.put(246, 182);
        unicodeToWidthsTableIndex.put(339, 183);
        unicodeToWidthsTableIndex.put(731, 184);
        unicodeToWidthsTableIndex.put(242, 185);
        unicodeToWidthsTableIndex.put(49, 186);
        unicodeToWidthsTableIndex.put(189, 187);
        unicodeToWidthsTableIndex.put(188, 188);
        unicodeToWidthsTableIndex.put(185, 189);
        unicodeToWidthsTableIndex.put(170, 190);
        unicodeToWidthsTableIndex.put(186, 191);
        unicodeToWidthsTableIndex.put(248, 192);
        unicodeToWidthsTableIndex.put(245, 193);
        unicodeToWidthsTableIndex.put(175, 194);
        unicodeToWidthsTableIndex.put(112, 195);
        unicodeToWidthsTableIndex.put(182, 196);
        unicodeToWidthsTableIndex.put(40, 197);
        unicodeToWidthsTableIndex.put(41, 198);
        unicodeToWidthsTableIndex.put(37, 199);
        unicodeToWidthsTableIndex.put(46, 200);
        unicodeToWidthsTableIndex.put(183, 201);
        unicodeToWidthsTableIndex.put(8240, 202);
        unicodeToWidthsTableIndex.put(43, 203);
        unicodeToWidthsTableIndex.put(177, 204);
        unicodeToWidthsTableIndex.put(8478, 205);
        unicodeToWidthsTableIndex.put(113, 206);
        unicodeToWidthsTableIndex.put(63, 207);
        unicodeToWidthsTableIndex.put(191, 208);
        unicodeToWidthsTableIndex.put(34, 209);
        unicodeToWidthsTableIndex.put(8222, 210);
        unicodeToWidthsTableIndex.put(8220, 211);
        unicodeToWidthsTableIndex.put(8221, 212);
        unicodeToWidthsTableIndex.put(8216, 213);
        unicodeToWidthsTableIndex.put(8217, 214);
        unicodeToWidthsTableIndex.put(8218, 215);
        unicodeToWidthsTableIndex.put(39, 216);
        unicodeToWidthsTableIndex.put(114, 217);
        unicodeToWidthsTableIndex.put(174, 218);
        unicodeToWidthsTableIndex.put(65533, 219);
        unicodeToWidthsTableIndex.put(730, 220);
        unicodeToWidthsTableIndex.put(115, 221);
        unicodeToWidthsTableIndex.put(353, 222);
        unicodeToWidthsTableIndex.put(351, 223);
        unicodeToWidthsTableIndex.put(167, 224);
        unicodeToWidthsTableIndex.put(59, 225);
        unicodeToWidthsTableIndex.put(55, 226);
        unicodeToWidthsTableIndex.put(54, 227);
        unicodeToWidthsTableIndex.put(47, 228);
        unicodeToWidthsTableIndex.put(32, 229);
        unicodeToWidthsTableIndex.put(65533, 230);
        unicodeToWidthsTableIndex.put(163, 231);
        unicodeToWidthsTableIndex.put(65533, 232);
        unicodeToWidthsTableIndex.put(116, 233);
        unicodeToWidthsTableIndex.put(65533, 234);
        unicodeToWidthsTableIndex.put(254, 235);
        unicodeToWidthsTableIndex.put(51, 236);
        unicodeToWidthsTableIndex.put(190, 237);
        unicodeToWidthsTableIndex.put(179, 238);
        unicodeToWidthsTableIndex.put(732, 239);
        unicodeToWidthsTableIndex.put(8482, 240);
        unicodeToWidthsTableIndex.put(50, 241);
        unicodeToWidthsTableIndex.put(178, 242);
        unicodeToWidthsTableIndex.put(117, 243);
        unicodeToWidthsTableIndex.put(250, 244);
        unicodeToWidthsTableIndex.put(251, 245);
        unicodeToWidthsTableIndex.put(252, 246);
        unicodeToWidthsTableIndex.put(249, 247);
        unicodeToWidthsTableIndex.put(95, 248);
        unicodeToWidthsTableIndex.put(65533, 249);
        unicodeToWidthsTableIndex.put(118, 250);
        unicodeToWidthsTableIndex.put(119, 251);
        unicodeToWidthsTableIndex.put(120, 252);
        unicodeToWidthsTableIndex.put(121, 253);
        unicodeToWidthsTableIndex.put(253, 254);
        unicodeToWidthsTableIndex.put(255, 255);
        unicodeToWidthsTableIndex.put(165, 256);
        unicodeToWidthsTableIndex.put(122, 257);
        unicodeToWidthsTableIndex.put(382, 258);
        unicodeToWidthsTableIndex.put(48, 259);
    }
}

