/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapCodesSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapObjectCache;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapObjectImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CMapResourceBuilder {
    private final HashMap<String, HashMap<Long, Integer>> spaceCIDToUnicodeMap = new HashMap();
    static Pattern registryPattern = Pattern.compile(" */Registry ?\\(([A-Za-z0-9]*)\\) ?def");
    static Pattern orderingPattern = Pattern.compile(" */Ordering ?\\(([A-Za-z0-9-_]*)\\) ?def");
    static Pattern supplementPattern = Pattern.compile(" */Supplement ([0-9]) def");
    static Pattern writingModePattern = Pattern.compile("[\\p{Print}\\s]*?/WMode\\s*([0-1])\\s*def[\\p{Print}\\s]*?");
    static Pattern cmapVersionPattern = Pattern.compile("/CMapVersion ([^ ]*) def");
    static Pattern cmapTypePattern = Pattern.compile("/CMapType ([1-2]) def");
    static Pattern cmapNamePattern = Pattern.compile(" */CMapName /([A-Za-z0-9-]*) def");
    static Pattern useCMapNamePattern = Pattern.compile(" */([A-Za-z0-9-]*) usecmap");
    static Pattern codesSpaceRangePattern = Pattern.compile("([0-9]*) begincodespacerange");
    static Pattern codesSpacePattern = Pattern.compile("\\s*<?([0-9a-fA-F]*)>\\s*<([0-9a-fA-F]*)>?");
    static Pattern beginnotdefrangePattern = Pattern.compile("([0-9]*) beginnotdefrange");
    static Pattern notdefrangePattern = Pattern.compile("<?([0-9a-fA-F]*)>\\s*<([0-9a-fA-F]*)>\\s*([0-9]*)");
    static Pattern beginbfcharPattern = Pattern.compile("\\s*([0-9]*) beginbfchar");
    static Pattern bfcharPattern = Pattern.compile("<?([0-9a-fA-F]*)>\\s*<([0-9a-fA-F]*)>?");
    static Pattern beginbfcharPatternForToUnicodeCMap = Pattern.compile("[\\p{Print}\\s]*?(([0-9]*)\\s+beginbfchar)[\\p{Print}\\s]*?");
    static String regExToMatchUnicodeCharName = "!-;?-~";
    static Pattern bfcharPatternForToUnicodeCMap = Pattern.compile("(\\s*<?\\s*([0-9a-fA-F]*)\\s*>\\s*((<\\s*([0-9a-fA-F]*)\\s*>?\\s*)|([" + regExToMatchUnicodeCharName + "]+)))[\\p{Print}\\s]*?");
    static Pattern beginbfrangePattern = Pattern.compile("\\s*([0-9]*) beginbfrange");
    static Pattern bfrangePattern = Pattern.compile("<?([0-9a-fA-F]*)>\\s*<([0-9a-fA-F]*)>\\s*<([0-9a-fA-F]*)>?");
    static Pattern beginbfrangePatternForToUnicodeCMap = Pattern.compile("[\\p{Print}\\s]*?(([0-9]*)\\s+beginbfrange)[\\p{Print}\\s]*?");
    static Pattern bfrangePatternForToUnicodeCMap = Pattern.compile("(\\s*<?\\s*([0-9a-fA-F]*)\\s*>\\s*<\\s*([0-9a-fA-F]*)\\s*>\\s*((<\\s*([0-9a-fA-F]*)\\s*>?\\s*)|([" + regExToMatchUnicodeCharName + "]+)))[\\p{Print}\\s]*?");
    static Pattern bfrangePatternWithDiscontnuousDststrForToUnicodeCMap = Pattern.compile("(<?\\s*([0-9a-fA-F]*)\\s*>\\s*<\\s*([0-9a-fA-F]*)\\s*>\\s*\\[\\s*((((<\\s*[0-9a-fA-F]*\\s*>?)|([" + regExToMatchUnicodeCharName + "]*?))\\s*)*+)\\])[\\p{Print}\\s]*?");
    static Pattern begincidcharPattern = Pattern.compile("([0-9]*) begincidchar");
    static Pattern cidcharPattern = Pattern.compile("\\s*<?([0-9a-fA-F]*)>\\s*([0-9]*)");
    static Pattern begincidrangePattern = Pattern.compile("([0-9]*) begincidrange");
    static Pattern cidrangePattern = Pattern.compile("\\s*<?([0-9a-fA-F]*)>\\s*<([0-9a-fA-F]*)>?\\s*([0-9]*)");
    private static final int DSTR_TYPE_SIMPLE = 0;
    private static final int DSTR_TYPE_DISCONTINUOUS = 1;
    private static CMapResourceBuilder _instance = new CMapResourceBuilder();
    private static Set<Character> numberSet = CMapResourceBuilder.addNumbersToCharacterSet();

    private CMapResourceBuilder() {
    }

    static CMapResourceBuilder getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PDFWritingMode getWMode(CosStream cmapObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        BufferedReader cmapLineReader = null;
        InputByteStream decodedCmapStream = null;
        InputStream cmapStream = null;
        try {
            try {
                Matcher patternMatcher;
                block32: {
                    decodedCmapStream = cmapObj.getStreamDecoded();
                    cmapStream = decodedCmapStream.toInputStream();
                    cmapLineReader = new LineNumberReader(new InputStreamReader(cmapStream));
                    String lineRead = "";
                    StringBuilder strToMatch = new StringBuilder(100);
                    while ((lineRead = ((LineNumberReader)cmapLineReader).readLine()) != null) {
                        if (!lineRead.contains(ASName.k_WMode.asString(true))) continue;
                        strToMatch.append(lineRead);
                        patternMatcher = writingModePattern.matcher(strToMatch);
                        if (!patternMatcher.matches()) {
                            continue;
                        }
                        break block32;
                    }
                    return PDFWritingMode.HORIZONTAL;
                }
                int writingMode = Integer.parseInt(patternMatcher.group(1));
                PDFWritingMode pDFWritingMode = PDFWritingMode.getWritingModeForValue(writingMode);
                return pDFWritingMode;
            }
            finally {
                try {
                    if (cmapLineReader != null) {
                        cmapLineReader.close();
                    }
                }
                finally {
                    try {
                        if (cmapStream != null) {
                            cmapStream.close();
                        }
                    }
                    finally {
                        if (decodedCmapStream != null) {
                            decodedCmapStream.close();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getReferencedCmaps(CosStream cmapObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        BufferedReader cmapLineReader = null;
        InputByteStream decodedCmapStream = null;
        InputStream cmapStream = null;
        ArrayList<String> cmapList = null;
        try {
            try {
                decodedCmapStream = cmapObj.getStreamDecoded();
                cmapStream = decodedCmapStream.toInputStream();
                cmapLineReader = new LineNumberReader(new InputStreamReader(cmapStream));
                String lineRead = "";
                StringBuilder strToMatch = new StringBuilder(100);
                while ((lineRead = ((LineNumberReader)cmapLineReader).readLine()) != null) {
                    if (!lineRead.contains("usecmap")) continue;
                    strToMatch.append(lineRead);
                    Matcher m = useCMapNamePattern.matcher(strToMatch);
                    if (!m.matches()) continue;
                    if (cmapList == null) {
                        cmapList = new ArrayList<String>();
                    }
                    cmapList.add(m.group(1));
                }
            }
            finally {
                try {
                    if (cmapLineReader != null) {
                        cmapLineReader.close();
                    }
                }
                finally {
                    try {
                        if (cmapStream != null) {
                            cmapStream.close();
                        }
                    }
                    finally {
                        if (decodedCmapStream != null) {
                            decodedCmapStream.close();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return cmapList;
    }

    public static Set<PDFToUnicodeCMap.CMapCodeMapping> parseToUnicodeMap(InputStream inputStream, boolean ignoreErrors) throws PDFIOException, PDFParseException {
        LinkedHashSet<PDFToUnicodeCMap.CMapCodeMapping> codeMapSet = new LinkedHashSet<PDFToUnicodeCMap.CMapCodeMapping>();
        LineNumberReader toUnicodeCMapLineReader = new LineNumberReader(new InputStreamReader(inputStream));
        try {
            String lineRead = CMapResourceBuilder.convertToSingleLine(toUnicodeCMapLineReader);
            StringBuilder strToMatch = new StringBuilder(8192);
            strToMatch.append(CMapResourceBuilder.validateCodeSpaceRangeExistence(lineRead));
            List<String> unicodeSubSequence = CMapResourceBuilder.splitToUnicodeSubSequence(lineRead);
            Matcher beginbfcharPatternMatcher = beginbfcharPatternForToUnicodeCMap.matcher(strToMatch);
            Matcher bfcharPatternMatcher = bfcharPatternForToUnicodeCMap.matcher(strToMatch);
            Matcher beginbfrangePatternMatcher = beginbfrangePatternForToUnicodeCMap.matcher(strToMatch);
            Matcher bfrangePatternMatcher = bfrangePatternForToUnicodeCMap.matcher(strToMatch);
            Matcher bfrangeWithDiscontinuousDststrPatternMatcher = bfrangePatternWithDiscontnuousDststrForToUnicodeCMap.matcher(strToMatch);
            Iterator<String> iter = unicodeSubSequence.iterator();
            while (iter.hasNext()) {
                int count;
                strToMatch.delete(0, strToMatch.length());
                strToMatch.append(iter.next());
                if (strToMatch.toString().contains(ASName.k_beginbfchar.asString(true))) {
                    beginbfcharPatternMatcher.reset(strToMatch);
                    if (beginbfcharPatternMatcher.matches()) {
                        int charCount = Integer.parseInt(beginbfcharPatternMatcher.group(2));
                        strToMatch.delete(0, beginbfcharPatternMatcher.end(1));
                        CMapResourceBuilder.preProcessToUniCodeCMapData(strToMatch);
                        String endbfchar = ASName.k_endbfchar.asString(true);
                        count = 0;
                        int badCount = 0;
                        while (count < charCount && !strToMatch.toString().trim().equals(endbfchar) && badCount <= 2 * charCount) {
                            block19: {
                                ++badCount;
                                bfcharPatternMatcher.reset(strToMatch);
                                if (!bfcharPatternMatcher.matches()) continue;
                                ++count;
                                try {
                                    CMapResourceBuilder.addCMapCodeMappingForBfcharToCodeMapSet(bfcharPatternMatcher, codeMapSet);
                                }
                                catch (NumberFormatException e) {
                                    if (ignoreErrors) break block19;
                                    throw e;
                                }
                            }
                            strToMatch.delete(0, bfcharPatternMatcher.end(1));
                        }
                        continue;
                    }
                }
                if (!strToMatch.toString().contains(ASName.k_beginbfrange.asString(true))) continue;
                beginbfrangePatternMatcher.reset(strToMatch);
                if (!beginbfrangePatternMatcher.matches()) continue;
                int rangeCount = Integer.parseInt(beginbfrangePatternMatcher.group(2));
                strToMatch.delete(0, beginbfrangePatternMatcher.end(1));
                CMapResourceBuilder.preProcessToUniCodeCMapData(strToMatch);
                String endbfrange = ASName.k_endbfrange.asString(true);
                count = 0;
                while (count < rangeCount && !strToMatch.toString().trim().equals(endbfrange)) {
                    String tempString = strToMatch.toString();
                    strToMatch.delete(0, strToMatch.length());
                    int indexOfFirstClosingBracket = tempString.indexOf(">", 0);
                    int indexOfSecondClosingBracket = tempString.indexOf(">", indexOfFirstClosingBracket + 1);
                    int indexOfThirdAngularOpeningBracket = tempString.indexOf("<", indexOfSecondClosingBracket);
                    int indexOfThirdSquareOpeningBracket = tempString.indexOf("[", indexOfSecondClosingBracket);
                    int indexOfLineBreak = -1;
                    indexOfLineBreak = indexOfThirdSquareOpeningBracket == -1 || indexOfThirdSquareOpeningBracket > indexOfThirdAngularOpeningBracket ? tempString.indexOf(">", indexOfThirdAngularOpeningBracket) : tempString.indexOf("]", indexOfThirdSquareOpeningBracket);
                    strToMatch.append(tempString.substring(0, indexOfLineBreak + 1).replaceAll(" ", ""));
                    if (strToMatch.toString().contains("[")) {
                        String subStr;
                        if (!strToMatch.toString().contains("]") && (subStr = strToMatch.substring(strToMatch.indexOf("["))).contains("<")) continue;
                        bfrangeWithDiscontinuousDststrPatternMatcher.reset(strToMatch);
                        if (bfrangeWithDiscontinuousDststrPatternMatcher.matches()) {
                            ++count;
                            CMapResourceBuilder.addCMapCodeMappingForBfcharRangeToCodeMapSet(bfrangeWithDiscontinuousDststrPatternMatcher, 1, codeMapSet);
                            strToMatch.delete(0, bfrangeWithDiscontinuousDststrPatternMatcher.end(1));
                            strToMatch.append(tempString.substring(indexOfLineBreak + 1));
                            continue;
                        }
                    }
                    bfrangePatternMatcher.reset(strToMatch);
                    if (!bfrangePatternMatcher.matches()) continue;
                    ++count;
                    CMapResourceBuilder.addCMapCodeMappingForBfcharRangeToCodeMapSet(bfrangePatternMatcher, 0, codeMapSet);
                    strToMatch.delete(0, bfrangePatternMatcher.end(1));
                    strToMatch.append(tempString.substring(indexOfLineBreak + 1));
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (toUnicodeCMapLineReader != null) {
                    toUnicodeCMapLineReader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return codeMapSet;
    }

    private static void preProcessToUniCodeCMapData(StringBuilder strToMatch) {
        String toProcess = strToMatch.toString();
        strToMatch.delete(0, strToMatch.length());
        for (int i = 0; i < toProcess.length(); ++i) {
            if (toProcess.charAt(i) == '<') {
                strToMatch.append(toProcess.charAt(i));
                ++i;
                while (toProcess.charAt(i) != '>') {
                    if (toProcess.charAt(i) != ' ') {
                        strToMatch.append(toProcess.charAt(i));
                    }
                    ++i;
                }
                strToMatch.append(toProcess.charAt(i));
                continue;
            }
            strToMatch.append(toProcess.charAt(i));
        }
    }

    private static List<String> splitToUnicodeSubSequence(String lineRead) {
        int startIndex;
        String beginbfchar = ASName.k_beginbfchar.asString(true);
        String endbfchar = ASName.k_endbfchar.asString(true);
        String beginbfrange = ASName.k_beginbfrange.asString(true);
        String endbfrange = ASName.k_endbfrange.asString(true);
        ArrayList<String> unicodeSubSequence = new ArrayList<String>(32);
        int indexOfbeginbfchar = -1;
        int indexOfendbfchar = -1;
        int nextIndexOfbeginbfchar = -1;
        int endIndex = startIndex = lineRead.indexOf(ASName.k_endcodespacerange.asString(true));
        boolean toContinue = true;
        while (toContinue) {
            indexOfbeginbfchar = lineRead.indexOf(beginbfchar, startIndex);
            indexOfendbfchar = lineRead.indexOf(endbfchar, startIndex);
            if (indexOfbeginbfchar == -1 || indexOfendbfchar == -1) break;
            if (indexOfbeginbfchar > indexOfendbfchar) {
                startIndex = endIndex = indexOfbeginbfchar;
                continue;
            }
            nextIndexOfbeginbfchar = lineRead.indexOf(beginbfchar, indexOfbeginbfchar + 1);
            if (nextIndexOfbeginbfchar != -1 && nextIndexOfbeginbfchar < indexOfendbfchar) {
                startIndex = nextIndexOfbeginbfchar;
                continue;
            }
            if (indexOfbeginbfchar != -1 && indexOfendbfchar != -1) {
                --indexOfbeginbfchar;
                while (lineRead.charAt(indexOfbeginbfchar) == ' ') {
                    --indexOfbeginbfchar;
                }
                while (numberSet.contains(Character.valueOf(lineRead.charAt(indexOfbeginbfchar)))) {
                    --indexOfbeginbfchar;
                }
                startIndex = ++indexOfbeginbfchar;
                endIndex = indexOfendbfchar + endbfchar.length();
                unicodeSubSequence.add(lineRead.substring(startIndex, endIndex));
            }
            startIndex = endIndex = indexOfendbfchar + endbfchar.length();
        }
        int indexOfbeginbfrange = -1;
        int indexOfendbfrange = -1;
        int nextIndexOfbeginbfrange = -1;
        endIndex = startIndex = lineRead.indexOf(ASName.k_endcodespacerange.asString(true));
        toContinue = true;
        while (toContinue) {
            indexOfbeginbfrange = lineRead.indexOf(beginbfrange, startIndex);
            indexOfendbfrange = lineRead.indexOf(endbfrange, startIndex);
            if (indexOfbeginbfrange == -1 || indexOfendbfrange == -1) break;
            if (indexOfbeginbfrange > indexOfendbfrange) {
                startIndex = endIndex = indexOfbeginbfrange;
                continue;
            }
            nextIndexOfbeginbfrange = lineRead.indexOf(beginbfrange, indexOfbeginbfrange + 1);
            if (nextIndexOfbeginbfrange != -1 && nextIndexOfbeginbfrange < indexOfendbfrange) {
                startIndex = nextIndexOfbeginbfrange;
                continue;
            }
            if (indexOfbeginbfrange != -1 && indexOfendbfrange != -1) {
                --indexOfbeginbfrange;
                while (lineRead.charAt(indexOfbeginbfrange) == ' ') {
                    --indexOfbeginbfrange;
                }
                while (numberSet.contains(Character.valueOf(lineRead.charAt(indexOfbeginbfrange)))) {
                    --indexOfbeginbfrange;
                }
                startIndex = ++indexOfbeginbfrange;
                endIndex = indexOfendbfrange + endbfrange.length();
                unicodeSubSequence.add(lineRead.substring(startIndex, endIndex));
            }
            startIndex = endIndex = indexOfendbfrange + endbfchar.length();
        }
        return unicodeSubSequence;
    }

    private static Set<Character> addNumbersToCharacterSet() {
        HashSet<Character> numberSet = new HashSet<Character>();
        numberSet.add(Character.valueOf('0'));
        numberSet.add(Character.valueOf('1'));
        numberSet.add(Character.valueOf('2'));
        numberSet.add(Character.valueOf('3'));
        numberSet.add(Character.valueOf('4'));
        numberSet.add(Character.valueOf('5'));
        numberSet.add(Character.valueOf('6'));
        numberSet.add(Character.valueOf('7'));
        numberSet.add(Character.valueOf('8'));
        numberSet.add(Character.valueOf('9'));
        return numberSet;
    }

    private static String convertToSingleLine(LineNumberReader toUnicodeCMapLineReader) throws IOException {
        StringBuilder sb = new StringBuilder(8192);
        String lineRead = toUnicodeCMapLineReader.readLine();
        if (lineRead != null) {
            sb.append(lineRead);
        }
        while ((lineRead = toUnicodeCMapLineReader.readLine()) != null) {
            sb.append(" ");
            sb.append(lineRead);
        }
        return sb.toString();
    }

    private static String validateCodeSpaceRangeExistence(String toUnicodeCMAPString) throws IOException, PDFParseException {
        if (toUnicodeCMAPString.contains(ASName.k_begincodespacerange.asString(true))) {
            return toUnicodeCMAPString;
        }
        throw new PDFParseException("ToUnicodeCmap could not be parsed: missing token \"begincodespacerange\"");
    }

    private static void addCMapCodeMappingForBfcharToCodeMapSet(Matcher bfCharPatternMatcher, Set<PDFToUnicodeCMap.CMapCodeMapping> codeMapSet) throws PDFParseException {
        int srcCode = Integer.parseInt(bfCharPatternMatcher.group(2), 16);
        PDFToUnicodeCMap.CMapCodeMapping codeMap = new PDFToUnicodeCMap.CMapCodeMapping(srcCode);
        String dstString = "";
        if (bfCharPatternMatcher.group(5) != null) {
            dstString = bfCharPatternMatcher.group(5);
            codeMap.addHexData(CMapResourceBuilder.hexStringToByteArray(dstString));
        } else {
            dstString = bfCharPatternMatcher.group(3);
            codeMap.addCharName(dstString);
        }
        codeMapSet.add(codeMap);
    }

    private static void addCMapCodeMappingForBfcharRangeToCodeMapSet(Matcher bfCharRangePatternMatcher, int dstStringType, Set<PDFToUnicodeCMap.CMapCodeMapping> codeMapSet) throws PDFParseException {
        int srcCode1 = Integer.parseInt(bfCharRangePatternMatcher.group(2), 16);
        int srcCode2 = Integer.parseInt(bfCharRangePatternMatcher.group(3), 16);
        PDFToUnicodeCMap.CMapCodeMapping codeMap = new PDFToUnicodeCMap.CMapCodeMapping(srcCode1, srcCode2);
        String dstString = "";
        switch (dstStringType) {
            case 0: {
                dstString = "";
                if (bfCharRangePatternMatcher.group(6) != null) {
                    dstString = bfCharRangePatternMatcher.group(6);
                    codeMap.addHexData(CMapResourceBuilder.hexStringToByteArray(dstString));
                    break;
                }
                dstString = bfCharRangePatternMatcher.group(4);
                codeMap.addCharName(dstString);
                break;
            }
            case 1: {
                dstString = bfCharRangePatternMatcher.group(4);
                String[] unicodeStrs = dstString.split(">|\\s+");
                for (int i = 0; i < unicodeStrs.length; ++i) {
                    if (unicodeStrs[i].trim().equals("")) continue;
                    if (unicodeStrs[i].charAt(0) == '<') {
                        codeMap.addHexData(CMapResourceBuilder.hexStringToByteArray(unicodeStrs[i].substring(1, unicodeStrs[i].length())));
                        continue;
                    }
                    codeMap.addCharName(unicodeStrs[i]);
                }
                break;
            }
        }
        codeMapSet.add(codeMap);
    }

    private static byte[] hexStringToByteArray(String hexStr) throws PDFParseException {
        byte[] strBytes = hexStr.getBytes();
        if (strBytes.length % 2 == 1) {
            hexStr = "0" + hexStr;
            strBytes = hexStr.getBytes();
        }
        byte[] hexBytes = new byte[strBytes.length / 2];
        int start = 0;
        int end = strBytes.length;
        int index = 0;
        for (int i = start; i < end; i += 2) {
            byte l;
            byte h;
            try {
                h = CosToken.toHexDigit(strBytes[i]);
                l = CosToken.toHexDigit(strBytes[i + 1]);
            }
            catch (PDFCosParseException e) {
                throw new PDFParseException(e);
            }
            hexBytes[index++] = (byte)(h * 16 + l);
        }
        return hexBytes;
    }

    CMapObject parseCMapFile(String fileName, boolean getCodesSpaceRangeOnly, HashMap<Long, Integer> spaceCharacterCodeToUnicodeMap, boolean printStats) throws Exception {
        CMapObject cmap = CMapObjectCache.getCmap(fileName, this, spaceCharacterCodeToUnicodeMap);
        if (cmap == null) {
            throw new MissingResourceException("Cannot load CMap resource " + fileName, "", "");
        }
        return cmap;
    }

    public static HashMap<String, CMapObject> getPredefinedCmaps() throws Exception {
        HashMap<String, CMapObject> cmapObjectCache = CMapObjectCache.getPredefinedCmaps(CMapResourceBuilder.getInstance(), new HashMap<Long, Integer>());
        if (cmapObjectCache == null) {
            throw new MissingResourceException("Cannot load CMap resources", "", "");
        }
        return cmapObjectCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CMapObject parseCMapFile(LineNumberReader f, Map<String, InputStream> useCMaps, boolean getCodesSpaceRangeOnly, HashMap<Long, Integer> spaceCharacterCodeToUnicodeMap, boolean printStats) throws Exception {
        try {
            String line;
            String registry = "?";
            String ordering = "?";
            String writingMode = "0";
            String cmapVersion = "?";
            String cmapName = "?";
            String useCMapName = null;
            CMapType cmapType = null;
            boolean isCodesSpacesDefined = false;
            CMapCodesSpace[] codesSpaces = null;
            HashMap<Long, int[]> map = new HashMap<Long, int[]>();
            HashMap<Long, Integer> charCodeToCIDMap = null;
            HashMap<Long, int[]> charCodeToCIDMapLong = null;
            int supplement = 0;
            int minBytes = 100;
            int maxBytes = 1;
            while ((line = f.readLine()) != null) {
                int charCode;
                long charCode1;
                Matcher m2;
                int i;
                Matcher m = registryPattern.matcher(line);
                if (m.matches()) {
                    registry = m.group(1);
                    continue;
                }
                m = orderingPattern.matcher(line);
                if (m.matches()) {
                    ordering = m.group(1);
                    continue;
                }
                m = supplementPattern.matcher(line);
                if (m.matches()) {
                    supplement = m.group(1).charAt(0) - 48;
                    continue;
                }
                m = writingModePattern.matcher(line);
                if (m.matches()) {
                    writingMode = m.group(1);
                    continue;
                }
                m = cmapVersionPattern.matcher(line);
                if (m.matches()) {
                    cmapVersion = m.group(1);
                    continue;
                }
                m = cmapTypePattern.matcher(line);
                if (m.matches()) {
                    String cmapTypeStr = m.group(1);
                    if ("1".equals(cmapTypeStr)) {
                        cmapType = CMapType.StandardCMap;
                        continue;
                    }
                    if ("2".equals(cmapTypeStr)) {
                        cmapType = CMapType.ToUnicodeMap;
                        continue;
                    }
                    throw new IllegalArgumentException("CMapType " + cmapTypeStr + " is invalid.");
                }
                m = cmapNamePattern.matcher(line);
                if (m.matches()) {
                    cmapName = m.group(1);
                    continue;
                }
                m = useCMapNamePattern.matcher(line);
                if (m.matches()) {
                    useCMapName = m.group(1);
                    CMapObject useCMapObject = null;
                    useCMapObject = useCMaps != null && useCMaps.containsKey(useCMapName) ? this.parseCMapFile(new LineNumberReader(new InputStreamReader(useCMaps.get(useCMapName))), useCMaps, getCodesSpaceRangeOnly, spaceCharacterCodeToUnicodeMap, printStats) : this.parseCMapFile(useCMapName, getCodesSpaceRangeOnly, spaceCharacterCodeToUnicodeMap, printStats);
                    codesSpaces = useCMapObject.getCodesSpaces();
                    minBytes = useCMapObject.getMinBytesNeeded();
                    maxBytes = useCMapObject.getMaxBytesAllowed();
                    if (codesSpaces == null || codesSpaces.length <= 0) continue;
                    isCodesSpacesDefined = true;
                    continue;
                }
                m = codesSpaceRangePattern.matcher(line);
                if (m.matches()) {
                    if (m.matches()) {
                        int codesSpaceCount = Integer.parseInt(m.group(1));
                        codesSpaces = new CMapCodesSpace[codesSpaceCount];
                        for (i = 0; i < codesSpaceCount; ++i) {
                            int tempBytes;
                            line = f.readLine();
                            m2 = codesSpacePattern.matcher(line);
                            if (!m2.matches()) {
                                throw new IllegalArgumentException();
                            }
                            long code1 = Long.parseLong(m2.group(1), 16);
                            long code2 = Long.parseLong(m2.group(2), 16);
                            codesSpaces[i] = new CMapCodesSpace(code1, code2);
                            if (!isCodesSpacesDefined) {
                                isCodesSpacesDefined = true;
                            }
                            if (minBytes > (tempBytes = m2.group(1).length() / 2)) {
                                minBytes = tempBytes;
                            }
                            if (maxBytes >= tempBytes) continue;
                            maxBytes = tempBytes;
                        }
                    }
                    if (!getCodesSpaceRangeOnly) continue;
                    break;
                }
                m = beginnotdefrangePattern.matcher(line);
                if (m.matches()) {
                    cmapType = CMapResourceBuilder.checkOperatorCompatibity(cmapType, CMapType.StandardCMap, isCodesSpacesDefined);
                    int rangeCount = Integer.parseInt(m.group(1));
                    for (i = 0; i < rangeCount; ++i) {
                        line = f.readLine();
                        m2 = notdefrangePattern.matcher(line);
                        if (!m2.matches()) {
                            throw new IllegalArgumentException();
                        }
                        charCode1 = Long.parseLong(m2.group(1), 16);
                        long charCode2 = Long.parseLong(m2.group(2), 16);
                        int cid = Integer.parseInt(m2.group(3), 10);
                        charCode = 0;
                        while ((long)charCode < charCode2 - charCode1 + 1L) {
                            int[] cidsTemp = new int[]{cid};
                            map.put((long)charCode + charCode1, cidsTemp);
                            ++charCode;
                        }
                    }
                    continue;
                }
                m = beginbfcharPattern.matcher(line);
                if (m.matches()) {
                    cmapType = CMapResourceBuilder.checkOperatorCompatibity(cmapType, CMapType.ToUnicodeMap, isCodesSpacesDefined);
                    int charCount = Integer.parseInt(m.group(1));
                    for (i = 0; i < charCount; ++i) {
                        line = f.readLine();
                        m2 = bfcharPattern.matcher(line);
                        if (!m2.matches()) {
                            throw new IllegalArgumentException();
                        }
                        long cid = Long.parseLong(m2.group(1), 16);
                        String usvs = m2.group(2);
                        int[] unicodes = this.parseUnicodes(usvs);
                        map.put(cid, unicodes);
                        this.cacheSpaceCIDToUnicodeMap(cid, unicodes, ordering);
                    }
                    continue;
                }
                m = beginbfrangePattern.matcher(line);
                if (m.matches()) {
                    cmapType = CMapResourceBuilder.checkOperatorCompatibity(cmapType, CMapType.ToUnicodeMap, isCodesSpacesDefined);
                    int rangeCount = Integer.parseInt(m.group(1));
                    for (i = 0; i < rangeCount; ++i) {
                        line = f.readLine();
                        m2 = bfrangePattern.matcher(line);
                        if (!m2.matches()) {
                            throw new IllegalArgumentException();
                        }
                        long cid1 = Long.parseLong(m2.group(1), 16);
                        long cid2 = Long.parseLong(m2.group(2), 16);
                        String usvs = m2.group(3);
                        int[] usvsVals = this.parseUnicodes(usvs);
                        int valCount = usvsVals.length;
                        int cid = 0;
                        while ((long)cid < cid2 - cid1 + 1L) {
                            int[] usvsValsTemp = new int[valCount];
                            System.arraycopy(usvsVals, 0, usvsValsTemp, 0, usvsVals.length);
                            usvsValsTemp[valCount - 1] = usvsVals[valCount - 1] + cid;
                            map.put((long)cid + cid1, usvsValsTemp);
                            this.cacheSpaceCIDToUnicodeMap((long)cid + cid1, usvsValsTemp, ordering);
                            ++cid;
                        }
                    }
                    continue;
                }
                m = begincidcharPattern.matcher(line);
                if (m.matches()) {
                    cmapType = CMapResourceBuilder.checkOperatorCompatibity(cmapType, CMapType.StandardCMap, isCodesSpacesDefined);
                    int cidCount = Integer.parseInt(m.group(1));
                    for (i = 0; i < cidCount; ++i) {
                        line = f.readLine();
                        m2 = cidcharPattern.matcher(line);
                        if (!m2.matches()) {
                            throw new IllegalArgumentException();
                        }
                        long charCode2 = Long.parseLong(m2.group(1), 16);
                        int[] cids = new int[]{Integer.parseInt(m2.group(2), 10)};
                        map.put(charCode2, cids);
                        this.updateSpaceCharacterCodeToUnicodeMap(spaceCharacterCodeToUnicodeMap, charCode2, cids, registry, ordering);
                    }
                    continue;
                }
                m = begincidrangePattern.matcher(line);
                if (!m.matches()) continue;
                cmapType = CMapResourceBuilder.checkOperatorCompatibity(cmapType, CMapType.StandardCMap, isCodesSpacesDefined);
                int rangeCount = Integer.parseInt(m.group(1));
                for (i = 0; i < rangeCount; ++i) {
                    line = f.readLine();
                    m2 = cidrangePattern.matcher(line);
                    if (!m2.matches()) {
                        throw new IllegalArgumentException();
                    }
                    charCode1 = Long.parseLong(m2.group(1), 16);
                    long charCode2 = Long.parseLong(m2.group(2), 16);
                    int cid = Integer.parseInt(m2.group(3), 10);
                    charCode = 0;
                    while ((long)charCode < charCode2 - charCode1 + 1L) {
                        int[] cidsTemp = new int[]{cid + charCode};
                        map.put((long)charCode + charCode1, cidsTemp);
                        this.updateSpaceCharacterCodeToUnicodeMap(spaceCharacterCodeToUnicodeMap, (long)charCode + charCode1, cidsTemp, registry, ordering);
                        ++charCode;
                    }
                }
            }
            if (printStats) {
                System.out.println("    handling " + registry + " " + ordering + " " + cmapVersion);
            }
            if (cmapType == CMapType.StandardCMap || cmapType == CMapType.ToUnicodeMap) {
                CMapObjectImpl cMapObjectImpl;
                long count = 0L;
                int curCodesSpaceIdx = -1;
                if (useCMapName != null && !map.isEmpty()) {
                    charCodeToCIDMap = new HashMap<Long, Integer>();
                    charCodeToCIDMapLong = new HashMap<Long, int[]>();
                    for (Map.Entry entry : map.entrySet()) {
                        long code = (Long)entry.getKey();
                        this.AddCode(charCodeToCIDMap, charCodeToCIDMapLong, code, (int[])entry.getValue());
                        ++count;
                    }
                } else {
                    for (Map.Entry entry : map.entrySet()) {
                        long code = (Long)entry.getKey();
                        curCodesSpaceIdx = this.getCodesSpace(code, codesSpaces, curCodesSpaceIdx);
                        void codesSpace = codesSpaces[curCodesSpaceIdx];
                        codesSpace.addCode(code, (int[])entry.getValue());
                        ++count;
                    }
                }
                if (printStats) {
                    System.out.print("total:" + count);
                }
                if (cmapType == CMapType.StandardCMap) {
                    cMapObjectImpl = new CMapObjectImpl(registry, ordering, supplement, writingMode, cmapName, useCMapName, codesSpaces, minBytes, maxBytes, spaceCharacterCodeToUnicodeMap, charCodeToCIDMap, charCodeToCIDMapLong);
                    return cMapObjectImpl;
                }
                cMapObjectImpl = new CMapObjectImpl(registry, ordering, supplement, writingMode, cmapName, useCMapName, codesSpaces, minBytes, maxBytes, this.spaceCIDToUnicodeMap.get(ordering), null, null);
                return cMapObjectImpl;
            }
            CMapObject cMapObject = null;
            return cMapObject;
        }
        finally {
            f.close();
        }
    }

    private void AddCode(HashMap<Long, Integer> charCodeCIDMap, HashMap<Long, int[]> charCodeCIDMapLong, long code, int[] value) {
        if (code <= Integer.MAX_VALUE) {
            if (value.length > 1) {
                this.addLongCode(code, value, charCodeCIDMapLong);
            } else {
                this.addIntCode(code, value[0], charCodeCIDMap);
            }
        } else {
            this.addLongCode(code, value, charCodeCIDMapLong);
        }
    }

    private void addLongCode(long code, int[] values, HashMap<Long, int[]> charCodeCIDMapLong) {
        if (charCodeCIDMapLong == null) {
            charCodeCIDMapLong = new HashMap();
        }
        charCodeCIDMapLong.put(code, values);
    }

    private void addIntCode(long code, int value, HashMap<Long, Integer> charCodeCIDMap) {
        if (charCodeCIDMap == null) {
            charCodeCIDMap = new HashMap();
        }
        charCodeCIDMap.put(code, value);
    }

    private int getCodesSpace(long code, CMapCodesSpace[] codesSpaces, int curCodesSpaceIdx) throws IOException {
        CMapCodesSpace codesSpace = null;
        if (curCodesSpaceIdx != -1 && (codesSpace = codesSpaces[curCodesSpaceIdx]).isCodeInCodeSpace(code)) {
            return curCodesSpaceIdx;
        }
        for (int iCodesSpace = 0; iCodesSpace < codesSpaces.length; ++iCodesSpace) {
            codesSpace = codesSpaces[iCodesSpace];
            if (!codesSpace.isCodeInCodeSpace(code)) continue;
            return iCodesSpace;
        }
        throw new IOException("Code " + code + " is not in any codes space range.");
    }

    private int[] parseUnicodes(String usvs) {
        int[] values = new int[usvs.length() / 4];
        int value = -1;
        for (int idxUsv = 0; idxUsv < usvs.length(); idxUsv += 4) {
            value = idxUsv + 4 > usvs.length() ? Integer.parseInt(usvs.substring(idxUsv), 16) : Integer.parseInt(usvs.substring(idxUsv, idxUsv + 4), 16);
            values[idxUsv / 4] = value;
        }
        return values;
    }

    private void cacheSpaceCIDToUnicodeMap(long cid, int[] unicodes, String ordering) {
        if (unicodes.length == 1 && Character.getType(unicodes[0]) == 12) {
            HashMap<Object, Object> cidToUnicode;
            if (this.spaceCIDToUnicodeMap.containsKey(ordering)) {
                cidToUnicode = this.spaceCIDToUnicodeMap.get(ordering);
            } else {
                cidToUnicode = new HashMap();
                this.spaceCIDToUnicodeMap.put(ordering, cidToUnicode);
            }
            cidToUnicode.put(cid, unicodes[0]);
        }
    }

    private void updateSpaceCharacterCodeToUnicodeMap(HashMap<Long, Integer> spaceCharacterCodeToUnicodeMap, long charCode, int[] cid, String registry, String ordering) throws Exception {
        HashMap<Long, Integer> cidToUnicode;
        Set<Long> cids;
        String cidToUnicodeCMap;
        if (cid.length == 1 && this.spaceCIDToUnicodeMap.containsKey(cidToUnicodeCMap = registry + "_" + ordering + "_UCS2") && (cids = (cidToUnicode = this.spaceCIDToUnicodeMap.get(cidToUnicodeCMap)).keySet()).contains(cid[0])) {
            spaceCharacterCodeToUnicodeMap.put(charCode, cidToUnicode.get(cid[0]));
        }
    }

    private static CMapType checkOperatorCompatibity(CMapType existingCMapType, CMapType expectedCMapType, boolean isCodesSpacesDefined) throws IllegalArgumentException {
        if (!isCodesSpacesDefined) {
            throw new IllegalArgumentException("begincodesspacerange is not defined. Exit.");
        }
        if (existingCMapType == null) {
            return expectedCMapType;
        }
        if (expectedCMapType != existingCMapType) {
            throw new IllegalArgumentException("Mixing of operators begincidchar/begincidrange and beginbfchar/beginbfrange are found.");
        }
        return existingCMapType;
    }

    static enum CMapType {
        StandardCMap(1),
        ToUnicodeMap(2);

        int value = 0;

        private CMapType(int type) {
            this.value = type;
        }
    }
}

