/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import com.adobe.fontengine.font.opentype.GlyphNames;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdobeGlyphList {
    private static Map<String, Integer> afeUnicodeSingleValueMap = new HashMap<String, Integer>();
    private static Map<String, List<Integer>> afeUnicodeMultiValueMap = new HashMap<String, List<Integer>>();
    private static AdobeGlyphList glyphList = new AdobeGlyphList();
    private HashMap<String, Integer> toUnicodeMap = new HashMap();

    private AdobeGlyphList() {
        AdobeGlyphList.gibsonList(this.toUnicodeMap);
    }

    public static AdobeGlyphList get() {
        return glyphList;
    }

    public static boolean hasGlyphName(ASName glyphName) {
        if (glyphName != null) {
            String key = glyphName.asString();
            return AdobeGlyphList.glyphList.toUnicodeMap.containsKey(key) || afeUnicodeSingleValueMap.containsKey(key) || afeUnicodeMultiValueMap.containsKey(key);
        }
        return false;
    }

    public static boolean hasGlyphName(String glyphName) {
        if (glyphName != null) {
            return AdobeGlyphList.glyphList.toUnicodeMap.containsKey(glyphName) || afeUnicodeSingleValueMap.containsKey(glyphName) || afeUnicodeMultiValueMap.containsKey(glyphName);
        }
        return false;
    }

    public char[] toUnicode(ASName charName) {
        char[] chars = null;
        if (charName != null) {
            String key = charName.asString();
            Integer value = this.toUnicodeMap.get(key);
            if (value != null) {
                chars = new char[]{(char)value.intValue()};
            } else {
                value = afeUnicodeSingleValueMap.get(key);
                if (value != null) {
                    chars = new char[]{(char)value.intValue()};
                } else {
                    List<Integer> usvs = afeUnicodeMultiValueMap.get(key);
                    if (usvs != null && !usvs.isEmpty()) {
                        chars = new char[usvs.size()];
                        for (int i = 0; i < usvs.size(); ++i) {
                            chars[i] = (char)usvs.get(i).intValue();
                        }
                    }
                }
            }
            if (chars == null) {
                chars = new char[]{'\ufffd'};
            }
        }
        return chars;
    }

    public ASName[] fromUnicode(char unicode) {
        ArrayList<ASName> glyphNames = new ArrayList<ASName>();
        Integer unicodeValue = unicode;
        glyphNames = this.addFormUnicodeByAFESingleValueMap(unicodeValue, this.toUnicodeMap.entrySet(), glyphNames);
        glyphNames = this.addFormUnicodeByAFESingleValueMap(unicodeValue, afeUnicodeSingleValueMap.entrySet(), glyphNames);
        glyphNames = this.addFormUnicodeByAFEMultiValueMap(unicodeValue, afeUnicodeMultiValueMap.entrySet(), glyphNames);
        int nameCount = glyphNames.size();
        ASName[] nameArray = new ASName[nameCount];
        for (int i = 0; i < nameCount; ++i) {
            nameArray[i] = glyphNames.get(i);
        }
        return nameArray;
    }

    private static void gibsonList(HashMap<String, Integer> map) {
        map.put("0", 48);
        map.put("1", 49);
        map.put("2", 50);
        map.put("3", 51);
        map.put("4", 52);
        map.put("5", 53);
        map.put("6", 54);
        map.put("7", 55);
        map.put("8", 56);
        map.put("9", 57);
        map.put("[", 91);
        map.put("]", 93);
        map.put(",", 44);
        map.put("-", 45);
        map.put(".", 46);
        map.put("apple", 63743);
    }

    private ArrayList<ASName> addFormUnicodeByAFESingleValueMap(Integer unicodeValue, Set<Map.Entry<String, Integer>> entrySet, ArrayList<ASName> glyphNames) {
        if (entrySet != null && !entrySet.isEmpty()) {
            for (Map.Entry<String, Integer> entry : entrySet) {
                if (entry == null || !entry.getValue().equals(unicodeValue)) continue;
                glyphNames.add(ASName.create(entry.getKey()));
            }
        }
        return glyphNames;
    }

    private ArrayList<ASName> addFormUnicodeByAFEMultiValueMap(Integer unicodeValue, Set<Map.Entry<String, List<Integer>>> entrySet, ArrayList<ASName> glyphNames) {
        if (entrySet != null && !entrySet.isEmpty()) {
            for (Map.Entry<String, List<Integer>> entry : entrySet) {
                List<Integer> valueList = entry.getValue();
                if (valueList == null || valueList.isEmpty()) continue;
                Iterator<Integer> listIterator = valueList.iterator();
                while (listIterator.hasNext()) {
                    if (!listIterator.next().equals(unicodeValue)) continue;
                    glyphNames.add(ASName.create(entry.getKey()));
                }
            }
        }
        return glyphNames;
    }

    static {
        afeUnicodeSingleValueMap = GlyphNames.getAdobeGlyphNameList();
        afeUnicodeMultiValueMap = GlyphNames.getAdobeGlyphNameListMulti();
    }
}

