/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.Encoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.MacRomanEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.SymbolEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.ZapfDingbatsEncoding;
import java.util.HashMap;

public class StandardCharSetEncodings {
    private static final HashMap<ASName, Encoding> encodings = new HashMap();

    StandardCharSetEncodings() {
    }

    public static CharSetEncoding get(ASName name) throws PDFInvalidParameterException {
        Encoding encoding = encodings.get(name);
        if (encoding != null) {
            return (CharSetEncoding)encoding;
        }
        throw new PDFInvalidParameterException("no encoding table for the specified encoding exists internally");
    }

    public static CharSetEncoding getDefaultCharsetForFont(ASName fontName) {
        try {
            if (fontName == ASName.k_Symbol) {
                return StandardCharSetEncodings.get(ASName.k_SymbolEncoding);
            }
            if (fontName == ASName.k_ZapfDingbats) {
                return StandardCharSetEncodings.get(ASName.k_ZapfDingbatsEncoding);
            }
            return StandardCharSetEncodings.get(ASName.k_StandardEncoding);
        }
        catch (PDFInvalidParameterException e) {
            throw new RuntimeException("Couldn't fetch default encoding", e);
        }
    }

    static {
        encodings.put(ASName.k_MacRomanEncoding, MacRomanEncoding.getEncoding());
        encodings.put(ASName.k_WinAnsiEncoding, WinAnsiEncoding.getEncoding());
        encodings.put(ASName.k_StandardEncoding, StandardEncoding.getEncoding());
        encodings.put(ASName.k_SymbolEncoding, SymbolEncoding.getEncoding());
        encodings.put(ASName.k_ZapfDingbatsEncoding, ZapfDingbatsEncoding.getEncoding());
    }
}

