/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;

public enum PDFWritingMode {
    HORIZONTAL(0),
    VERTICAL(1);

    private final int mode;

    private PDFWritingMode(int mode) {
        this.mode = mode;
    }

    public String toString() {
        String modeStr = null;
        switch (this.mode) {
            case 0: {
                modeStr = "horizontal writing mode";
                break;
            }
            case 1: {
                modeStr = "vertical writing mode";
            }
        }
        return modeStr;
    }

    int getValue() {
        return this.mode;
    }

    public static final PDFWritingMode getWritingModeForValue(int modeValue) throws PDFInvalidParameterException {
        PDFWritingMode mode = null;
        switch (modeValue) {
            case 0: {
                mode = HORIZONTAL;
                break;
            }
            case 1: {
                mode = VERTICAL;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("illegal writing mode value");
            }
        }
        return mode;
    }
}

