/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistryBase;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDVerticalMetrics;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;

public class PDFFontType0
extends PDFFont {
    private static final int CIDSysInfoDictSize = 16384;
    boolean isSpaceCharFound;
    long spaceChar = -1L;

    private PDFFontType0(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFFontType0(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Type0);
    }

    private PDFFontType0(PDFDocument pdfDoc, Font afeFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc, afeFont);
        this.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Type0);
    }

    @Override
    public String toString() {
        return "Type0 Font: " + super.toString();
    }

    public static PDFFontType0 getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFontType0 pdfObject = (PDFFontType0)PDFCosObject.getCachedInstance(cosObject, PDFFontType0.class);
        if (pdfObject == null) {
            pdfObject = new PDFFontType0(cosObject);
        }
        return pdfObject;
    }

    public static PDFFont newInstance(PDFDocument pdfDocument, ASName baseFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontType0 pdfObject = new PDFFontType0(pdfDocument);
        pdfObject.setBaseFont(baseFont);
        return pdfObject;
    }

    public static PDFFont newInstance(PDFDocument pdfDocument, Font afeFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        PDFFontDescription pdfDesc = afeFont.getPDFFontDescription();
        ASName baseFont = ASName.create(pdfDesc.getPostscriptName());
        PDFFontType0 pdfObject = new PDFFontType0(pdfDocument, afeFont);
        pdfObject.setBaseFont(baseFont);
        return pdfObject;
    }

    public PDFType0FontEncoding getEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = this.getCosDictionary().get(ASName.k_Encoding);
        return PDFType0FontEncoding.getInstance(cosObj);
    }

    public void setEncoding(PDFType0FontEncoding encoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Encoding, encoding);
    }

    public PDFCIDFont getDescendantFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray array = this.getCosDictionary().getCosArray(ASName.k_DescendantFonts);
        if (array == null) {
            try {
                PDFDocument pdfDoc = this.getPDFDocument();
                ((DocumentListenerRegistryBase)pdfDoc.getListenerRegistry()).sendMessage(new DocumentMessage(DocumentMessage.FLUSH_FONTS, pdfDoc), true);
            }
            catch (PDFUnableToCompleteOperationException pDFUnableToCompleteOperationException) {
                // empty catch block
            }
            array = this.getCosDictionary().getCosArray(ASName.k_DescendantFonts);
        }
        return (PDFCIDFont)PDFFontFactory.getInstance(array.get(0));
    }

    public void setDescendantFont(PDFCIDFont cidFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
        cosArray.add(cidFont.getCosObject());
        this.setDictionaryArrayValue(ASName.k_DescendantFonts, cosArray);
    }

    @Override
    public PDFToUnicodeCMap getToUnicodeCMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = this.getCosDictionary().get(ASName.k_ToUnicode);
        return PDFToUnicodeCMap.getInstance(cosObj);
    }

    @Override
    public PDFWritingMode getWritingMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getEncoding().getWMode();
    }

    @Override
    public PDFFontDescriptor getFontDescriptor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCIDFont descendantFont = this.getDescendantFont();
        if (descendantFont != null) {
            return descendantFont.getFontDescriptor();
        }
        return null;
    }

    public void setFontDescriptor(PDFFontDescriptor fontDescriptor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCIDFont descendantFont = this.getDescendantFont();
        if (descendantFont != null) {
            descendantFont.setFontDescriptor(fontDescriptor);
        }
    }

    @Override
    public double getGlyphWidth(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int cid = this.getEncoding().getCIDFromCharBytes(charCodeBytes);
        return this.getGlyphWidthFromCID(cid);
    }

    public double getGlyphWidth(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int cid = this.getEncoding().getCID(charCode);
        return this.getGlyphWidthFromCID(cid);
    }

    public double getGlyphWidthFromCID(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCIDFont dFont = this.getDescendantFont();
        PDFCIDFontWidths widths = dFont.getW();
        if (widths != null && widths.containsWidth(cid)) {
            return widths.getWidth(cid);
        }
        return dFont.getDW();
    }

    public PDFCIDFontWidths getPDFCIDFontWidths() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCIDFont dFont = this.getDescendantFont();
        return dFont.getW();
    }

    @Override
    public double getGlyphHeight(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getGlyphHeight((int)PDFCMapUtils.getCharCode(charCodeBytes));
    }

    private double getGlyphHeight(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCIDFont dFont = this.getDescendantFont();
        PDFCIDVerticalMetrics metrics = dFont.getW2();
        int cid = this.getEncoding().getCID(charCode);
        if (metrics != null && metrics.containsMetric(cid)) {
            return metrics.getVerticalDisplacement(cid);
        }
        return dFont.getDW2()[1];
    }

    @Override
    public double getGlyphDisplacement(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getWritingMode() == PDFWritingMode.HORIZONTAL) {
            return this.getGlyphWidth(charCode);
        }
        return this.getGlyphHeight(charCode);
    }

    @Override
    public double getAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDescendantFont().getFontDescriptor().getAscent();
    }

    @Override
    public double getDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDescendantFont().getFontDescriptor().getDescent();
    }

    @Override
    public ASRectangle getBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDescendantFont().getFontDescriptor().getFontBBox();
    }

    @Override
    public char[] getUnicode(long charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List charCodesList = this.getCharCodes(PDFCMapUtils.numToByteArray(charCode, PDFFontUtils.getMinCharCodeBytes(this)), true);
        if (charCodesList == null) {
            throw new PDFInvalidDocumentException("Unicode cannot be found for char code " + charCode);
        }
        int[] unicodes = (int[])charCodesList.get(1);
        char[] ret = new char[unicodes.length];
        for (int i = 0; i < unicodes.length; ++i) {
            ret[i] = (char)unicodes[i];
        }
        return ret;
    }

    @Override
    public byte[] getSpaceCharCode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        long spaceChars;
        PDFType0FontEncoding fontEnc = this.getEncoding();
        PDFCMap pdfCMap = fontEnc.getPDFCMap();
        ASName cmapName = null;
        cmapName = fontEnc.getCMapName();
        PDFToUnicodeCMap toUnicodeCMap = this.getToUnicodeCMap();
        if (toUnicodeCMap != null) {
            if (this.isSpaceCharFound) {
                spaceChars = this.spaceChar;
            } else {
                this.spaceChar = spaceChars = (long)toUnicodeCMap.fromUnicode(' ');
                this.isSpaceCharFound = true;
            }
        } else if (cmapName == ASName.k_Identity_H || cmapName == ASName.k_Identity_V) {
            PDFCIDSystemInfo sysInfo = this.getDescendantFont().getCIDSystemInfo();
            try {
                spaceChars = pdfCMap.getSpaceCharCodeIdentity(sysInfo.getRegistry().toString(), sysInfo.getOrdering().toString());
            }
            catch (MissingResourceException e) {
                spaceChars = 32L;
            }
        } else {
            spaceChars = pdfCMap.getSpaceCharCode();
        }
        return PDFCMapUtils.numToByteArray(spaceChars, PDFFontUtils.getMinCharCodeBytes(this));
    }

    @Override
    public List getCharCodes(byte[] bytes, boolean fetchUnicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFontUtils.getCharCodes(bytes, fetchUnicode, true, this, false);
    }

    @Override
    public int charCode2gid(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        return PDFFontUtils.charCode2gid(charCode, this, this.getAFEFontData());
    }

    public void addEndDefToCIDSystemInfoDict() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        InputStream encodingStream = null;
        try {
            encodingStream = this.getCosDictionary().getStream(ASName.k_Encoding).toInputStream();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        byte[] encodingStreamBytes = null;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = encodingStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        try {
            buffer.flush();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        encodingStreamBytes = buffer.toByteArray();
        String encodingStreamString = new String(encodingStreamBytes);
        List<String> encodingStreamTokens = Arrays.asList(encodingStreamString.split("\\s+"));
        int supplementIndex = encodingStreamTokens.indexOf("/Supplement");
        String[] splitEncodingString = encodingStreamString.split("/Supplement\\s+\\d+\\s+def");
        String tempString = splitEncodingString[0] + encodingStreamTokens.get(supplementIndex) + " " + encodingStreamTokens.get(supplementIndex + 1) + " " + encodingStreamTokens.get(supplementIndex + 2) + "\nend def" + splitEncodingString[1];
        byte[] tempByteArray = tempString.getBytes();
        ByteArrayInputStream tempIS = new ByteArrayInputStream(tempByteArray);
        InputStreamByteReader reader = null;
        try {
            reader = new InputStreamByteReader(tempIS);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        InputByteStream tempByteStream = null;
        try {
            tempByteStream = this.getPDFDocument().getStreamManager().getInputByteStream(reader);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        this.getEncoding().getCosStream().newDataDecoded(tempByteStream);
    }
}

