/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;

public class PDFFontFactory {
    private PDFFontFactory() {
    }

    public static Object getInstance(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosObject instanceof CosDictionary) {
            CosDictionary cosDict = (CosDictionary)cosObject;
            if (cosDict.getName(ASName.k_Subtype) == ASName.k_Type0) {
                return PDFFontType0.getInstance(cosObject);
            }
            if (cosDict.getName(ASName.k_Subtype) == ASName.k_Type3) {
                return PDFFontType3.getInstance(cosObject);
            }
            if (cosDict.getName(ASName.k_Subtype) == ASName.k_CIDFontType0 || cosDict.getName(ASName.k_Subtype) == ASName.k_CIDFontType2) {
                return PDFCIDFont.getInstance(cosObject);
            }
            if (cosDict.getName(ASName.k_Subtype) == ASName.k_Type1 || cosDict.getName(ASName.k_Subtype) == ASName.k_TrueType || cosDict.getName(ASName.k_Subtype) == ASName.k_MMType1) {
                return PDFFontSimple.getInstance(cosObject, cosDict.getName(ASName.k_Subtype));
            }
        }
        throw new PDFInvalidDocumentException("unrecognized font format");
    }
}

