/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PDFColorSpaceIndexed
extends PDFColorSpace {
    public PDFColorSpaceIndexed(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceIndexed getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceIndexed pdfObject = (PDFColorSpaceIndexed)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceIndexed.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceIndexed(cosObject);
        }
        return pdfObject;
    }

    public static PDFColorSpaceIndexed newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFColorSpaceIndexed pdfObject = new PDFColorSpaceIndexed(cosObject);
        cosObject.addName(ASName.k_Indexed);
        cosObject.addName(ASName.k_DeviceRGB);
        cosObject.addInt(255);
        return pdfObject;
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        try {
            int size = this.getHighValue();
            byte[] index = this.getLookupData();
            int numberOfComponents = this.getNumberOfComponents();
            ColorModel cm = null;
            cm = numberOfComponents == 3 ? new IndexColorModel(bpc, size + 1, index, 0, false) : (numberOfComponents == 1 ? new IndexColorModel(bpc, size + 1, index, index, index) : this.getBaseColorSpace().createColorModel(bpc, transferType));
            return cm;
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public ColorSpace createColorSpace() {
        return ColorSpace.getInstance(1000);
    }

    @Override
    public ASName getName() {
        return ASName.k_Indexed;
    }

    @Override
    public int getNumberOfComponents() {
        try {
            return this.getBaseColorSpace().getNumberOfComponents();
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    public PDFColorSpace getBaseColorSpace() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject base = this.getCosArray().get(1);
        return PDFColorSpaceFactory.getInstance(base);
    }

    public void setBaseColorSpace(PDFColorSpace base) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (this.getCosArray().size() < 2) {
            this.getCosArray().add(1, base.getCosObject());
        } else {
            this.getCosArray().set(1, base.getCosObject());
        }
    }

    public int getHighValue() {
        try {
            return this.getCosArray().getInt(2);
        }
        catch (PDFCosParseException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    public void setHighValue(int high) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (this.getCosArray().size() < 3) {
            this.getCosArray().addInt(2, high);
        } else {
            this.getCosArray().setInt(2, high);
        }
    }

    public byte[] getLookupData() {
        try {
            CosObject lookupTable = this.getCosArray().get(3);
            byte[] data = null;
            if (lookupTable == null) {
                data = new byte[]{};
            } else if (lookupTable.getType() == 4) {
                data = ((CosString)lookupTable).byteArrayValue();
            } else if (lookupTable instanceof CosStream) {
                CosStream lookupStream = (CosStream)lookupTable;
                ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                lookupStream.copyStream(output, false);
                data = output.toByteArray();
            } else {
                throw new PDFIOException("Error: Unknown type for lookup table " + lookupTable);
            }
            return data;
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    public void setLookupData(byte[] byteString) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (byteString == null) {
            throw new PDFInvalidParameterException("Look up data in indexed color space can not be null.");
        }
        CosString string = PDFCosObject.newCosString(this.getPDFDocument(), byteString);
        if (this.getCosArray().size() < 4) {
            this.getCosArray().add(3, string);
        } else {
            this.getCosArray().set(3, string);
        }
    }

    public void setLookupColor(int componentNumber, int lookupIndex, int color, ColorModel cm) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        try {
            PDFColorSpace baseColor = this.getBaseColorSpace();
            int numberOfComponents = baseColor.getNumberOfComponents();
            byte[] data = new byte[768];
            data[componentNumber * numberOfComponents + lookupIndex] = (byte)color;
            CosStream string = this.getCosArray().getDocument().createCosStream(this.getCosArray().getDocument().getStreamManager().getInputByteStream(data));
            int[] arr = new int[768];
            int[] newArr = new int[256];
            ((IndexColorModel)cm).getRGBs(newArr);
            byte[] r = new byte[256];
            ((IndexColorModel)cm).getReds(r);
            byte[] g = new byte[256];
            ((IndexColorModel)cm).getGreens(g);
            byte[] b = new byte[256];
            ((IndexColorModel)cm).getBlues(b);
            for (int i = 0; i < 256; ++i) {
                arr[3 * i + 2] = b[i];
                arr[3 * i + 1] = g[i];
                arr[3 * i] = r[i];
            }
            OutputByteStream byteStream = this.getCosArray().getDocument().getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.FIXED, arr.length);
            for (int i = 0; i < arr.length; ++i) {
                byteStream.write(arr[i]);
            }
            InputByteStream inputByteStream = byteStream.closeAndConvert();
            string = this.getCosArray().getDocument().createCosStream(inputByteStream);
            if (this.getCosArray().size() < 4) {
                this.getCosArray().add(3, string);
            } else {
                this.getCosArray().set(3, string);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public double[] toRGB(double[] inputColorValues) {
        try {
            inputColorValues = super.toRGB(inputColorValues);
            PDFColorSpace baseCS = this.getBaseColorSpace();
            return ColorManager.indexedToRGB(inputColorValues, this.getLookupData(), this.getHighValue(), baseCS, baseCS.getRange(), baseCS.getNumberOfComponents());
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public double[] getRange() {
        return new double[]{0.0, this.getHighValue()};
    }

    @Override
    public double[] getDefaultColor() {
        return PDFColorSpaceDeviceGray.defaultColor;
    }
}

