/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.awt.geom.Rectangle2D;

public class PDFRectangle
extends PDFCosObject {
    private PDFRectangle(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRectangle getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRectangle pdfObject = (PDFRectangle)PDFCosObject.getCachedInstance(cosObject, PDFRectangle.class);
        if (pdfObject == null) {
            pdfObject = new PDFRectangle(cosObject);
        }
        return pdfObject;
    }

    public static PDFRectangle newInstance(PDFDocument pdfDocument, double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFRectangle pdfRectangle = new PDFRectangle(cosObject);
        cosObject.addDouble(llx);
        cosObject.addDouble(lly);
        cosObject.addDouble(urx);
        cosObject.addDouble(ury);
        return pdfRectangle;
    }

    public static PDFRectangle newInstance(PDFDocument pdfDocument, ASRectangle asRectangle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.newInstance(pdfDocument, asRectangle.left(), asRectangle.bottom(), asRectangle.right(), asRectangle.top());
    }

    public ASRectangle getRectangle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new ASRectangle(this.left(), this.bottom(), this.right(), this.top());
    }

    public double[] getValues() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getCosArray();
        double[] vals = new double[]{cosArray.getDouble(0), cosArray.getDouble(1), cosArray.getDouble(2), cosArray.getDouble(3)};
        return vals;
    }

    public PDFRectangle normalized(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] newVals = new double[]{Math.min(this.left(), this.right()), Math.min(this.bottom(), this.top()), Math.max(this.left(), this.right()), Math.max(this.bottom(), this.top())};
        return PDFRectangle.newInstance(pdfDocument, newVals[0], newVals[1], newVals[2], newVals[3]);
    }

    public double llx() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosArray().getDouble(0);
    }

    public double lly() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosArray().getDouble(1);
    }

    public double urx() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosArray().getDouble(2);
    }

    public double ury() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosArray().getDouble(3);
    }

    public double left() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.llx();
    }

    public double bottom() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.lly();
    }

    public double right() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.urx();
    }

    public double top() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.ury();
    }

    public double width() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return Math.abs(this.urx() - this.llx());
    }

    public double height() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return Math.abs(this.ury() - this.lly());
    }

    public boolean contains(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isRectContained = false;
        Rectangle2D.Double currentRectangle = new Rectangle2D.Double(this.llx(), this.lly(), this.urx() - this.llx(), this.ury() - this.lly());
        isRectContained = currentRectangle.contains(rect.llx(), rect.lly(), rect.urx() - rect.llx(), rect.ury() - rect.lly());
        return isRectContained;
    }

    public boolean intersects(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Rectangle2D.Double rectToCheck;
        boolean doesIntersect = false;
        Rectangle2D.Double currentRectangle = new Rectangle2D.Double(this.llx(), this.lly(), this.urx() - this.llx(), this.ury() - this.lly());
        if (currentRectangle.intersects(rectToCheck = new Rectangle2D.Double(rect.llx(), rect.lly(), Math.abs(rect.urx() - rect.llx()), Math.abs(rect.ury() - rect.lly())))) {
            doesIntersect = true;
        }
        return doesIntersect;
    }

    public PDFRectangle createUnion(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle newRect = null;
        Rectangle2D.Double currentRectangle = new Rectangle2D.Double(this.llx(), this.lly(), this.urx() - this.llx(), this.ury() - this.lly());
        Rectangle2D.Double givenRectangle = new Rectangle2D.Double(rect.llx(), rect.lly(), rect.urx() - rect.llx(), rect.ury() - rect.lly());
        Rectangle2D.Double unionRect = new Rectangle2D.Double();
        unionRect.setRect(currentRectangle.createUnion(givenRectangle));
        newRect = PDFRectangle.newInstance(this.getPDFDocument(), unionRect.x, unionRect.y, unionRect.x + unionRect.width, unionRect.y + unionRect.height);
        return newRect;
    }

    public PDFRectangle createIntersection(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle newRect = null;
        Rectangle2D.Double currentRectangle = new Rectangle2D.Double(this.llx(), this.lly(), this.urx() - this.llx(), this.ury() - this.lly());
        Rectangle2D.Double givenRectangle = new Rectangle2D.Double(rect.llx(), rect.lly(), rect.urx() - rect.llx(), rect.ury() - rect.lly());
        Rectangle2D.Double intersectRect = new Rectangle2D.Double();
        intersectRect.setRect(currentRectangle.createIntersection(givenRectangle));
        newRect = PDFRectangle.newInstance(this.getPDFDocument(), intersectRect.x, intersectRect.y, intersectRect.x + intersectRect.width, intersectRect.y + intersectRect.height);
        return newRect;
    }

    public boolean hasNonZeroDimensions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.llx() == 0.0 && this.lly() == 0.0 && this.urx() == 0.0 && this.ury() == 0.0) {
            return false;
        }
        return this.height() != 0.0 && this.width() != 0.0;
    }

    public boolean hasNonZeroDimensions(double epsilon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (Math.abs(this.llx()) < epsilon && Math.abs(this.lly()) < epsilon && Math.abs(this.urx()) < epsilon && Math.abs(this.ury()) < epsilon) {
            return false;
        }
        return !(this.height() < epsilon) && !(this.width() < epsilon);
    }

    public PDFRectangle rotate(int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle asRect = this.getRectangle();
        asRect = asRect.transform(PDFRectangle.getTransformationMatrix(rotationAngle));
        return PDFRectangle.newInstance(this.getPDFDocument(), asRect);
    }

    public static PDFRectangle rotate(PDFRectangle rect, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle asRect = rect.getRectangle();
        asRect = asRect.transform(PDFRectangle.getTransformationMatrix(rotationAngle));
        return PDFRectangle.newInstance(rect.getPDFDocument(), asRect);
    }

    private static ASMatrix getTransformationMatrix(int rotationAngle) {
        return ASMatrix.createIdentityMatrix().rotate(Math.toRadians(rotationAngle));
    }
}

