/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;

public enum PDFLineCap {
    BUTT_CAP(0),
    ROUND_CAP(1),
    PROJECTING_SQUARE_CAP(2);

    private final int lineCap;

    private PDFLineCap(int lineCap) {
        this.lineCap = lineCap;
    }

    public String toString() {
        String lineCapStr = null;
        switch (this.lineCap) {
            case 0: {
                lineCapStr = "butt cap";
                break;
            }
            case 1: {
                lineCapStr = "round cap";
                break;
            }
            case 2: {
                lineCapStr = "projecting square cap";
            }
        }
        return lineCapStr;
    }

    int getValue() {
        return this.lineCap;
    }

    public static final PDFLineCap getInstance(int lineCapValue) throws PDFInvalidParameterException {
        PDFLineCap lineCap = null;
        switch (lineCapValue) {
            case 0: {
                lineCap = BUTT_CAP;
                break;
            }
            case 1: {
                lineCap = ROUND_CAP;
                break;
            }
            case 2: {
                lineCap = PROJECTING_SQUARE_CAP;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("illegal line cap value");
            }
        }
        return lineCap;
    }
}

