/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document.permissionhandlers;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class ADBEUIPermissionHandler
extends PDFCosDictionary {
    public static ASName k_ADBEUIPerms = ASName.create("ADBE:UIPerms");
    private static ASName k_print = ASName.create("print");
    private static ASName k_email = ASName.create("email");
    private static ASName k_save = ASName.create("save");

    protected ADBEUIPermissionHandler(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static ADBEUIPermissionHandler getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        ADBEUIPermissionHandler pdfObject = (ADBEUIPermissionHandler)PDFCosObject.getCachedInstance(cosObject, ADBEUIPermissionHandler.class);
        if (pdfObject == null) {
            pdfObject = new ADBEUIPermissionHandler(cosObject);
        }
        return pdfObject;
    }

    public static ADBEUIPermissionHandler newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        ADBEUIPermissionHandler pdfObject = new ADBEUIPermissionHandler(cosObject);
        return pdfObject;
    }

    public boolean hasPrintPermission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(k_print);
    }

    public boolean getPrintPermission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_print);
    }

    public void setPrintPermission(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_print, value);
    }

    public boolean hasEmailPermission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(k_email);
    }

    public boolean getEmailPermission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_email);
    }

    public void setEmailPermission(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_email, value);
    }

    public boolean hasSavePermission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(k_save);
    }

    public boolean getSavePermission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_save);
    }

    public void setSavePermission(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_save, value);
    }
}

