/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;

public class PDFStreamList
extends PDFCosArrayList<PDFStream> {
    private PDFStreamList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFStreamList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStreamList pdfObject = (PDFStreamList)PDFCosObject.getCachedInstance(cosObject, PDFStreamList.class);
        if (pdfObject == null) {
            pdfObject = new PDFStreamList(cosObject);
        }
        return pdfObject;
    }

    public static PDFStreamList newInstance(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(doc);
        return new PDFStreamList(cosObject);
    }

    @Override
    protected PDFStream itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFStream.getInstance(cosObject);
    }

    public void addStream(PDFStream stream) {
        if (stream == null) {
            return;
        }
        if (!this.contains(stream)) {
            super.add(stream);
        }
    }

    public void addStreams(PDFStream[] streams) {
        if (streams == null) {
            return;
        }
        for (int i = 0; i < streams.length; ++i) {
            this.addStream(streams[i]);
        }
    }

    public PDFStream getStream(int index) {
        return (PDFStream)super.get(index);
    }
}

