/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;

public class PDFResources
extends PDFCosDictionary {
    private PDFResources(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFResources getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFResources pdfObject = (PDFResources)PDFCosObject.getCachedInstance(cosObject, PDFResources.class);
        if (pdfObject == null) {
            pdfObject = new PDFResources(cosObject);
        }
        return pdfObject;
    }

    public static PDFResources newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFResources pdfObject = new PDFResources(cosObject);
        ASName[] name = new ASName[]{ASName.k_PDF};
        pdfObject.setProcSetList(name);
        return pdfObject;
    }

    public PDFColorSpaceMap getColorSpaceMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFColorSpaceMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_ColorSpace));
    }

    public void setColorSpaceMap(PDFColorSpaceMap map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ColorSpace, map);
    }

    public PDFColorSpaceMap procureColorSpaceMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFColorSpaceMap pdfColorSpaceMap = this.getColorSpaceMap();
        if (pdfColorSpaceMap == null) {
            pdfColorSpaceMap = PDFColorSpaceMap.newInstance(this.getPDFDocument());
            this.setColorSpaceMap(pdfColorSpaceMap);
        }
        return pdfColorSpaceMap;
    }

    public void removeColorSpaceMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_ColorSpace);
    }

    public PDFColorSpace getColorSpace(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFColorSpaceMap csMap = this.getColorSpaceMap();
        if (csMap != null) {
            return csMap.get(name);
        }
        return null;
    }

    public PDFPatternMap getPatternMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPatternMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_Pattern));
    }

    public void setPatternMap(PDFPatternMap map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Pattern, map);
    }

    public PDFPatternMap procurePatternMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPatternMap pdfPatternMap = this.getPatternMap();
        if (pdfPatternMap == null) {
            pdfPatternMap = PDFPatternMap.newInstance(this.getPDFDocument());
            this.setPatternMap(pdfPatternMap);
        }
        return pdfPatternMap;
    }

    public void removePatternMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Pattern);
    }

    public PDFPattern getPattern(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPatternMap patternMap = this.getPatternMap();
        if (patternMap != null) {
            return patternMap.get(name);
        }
        return null;
    }

    public PDFShadingMap getShadingMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFShadingMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_Shading));
    }

    public void setShadingMap(PDFShadingMap map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Shading, map);
    }

    public PDFShadingMap procureShadingMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFShadingMap pdfShadingMap = this.getShadingMap();
        if (pdfShadingMap == null) {
            pdfShadingMap = PDFShadingMap.newInstance(this.getPDFDocument());
            this.setShadingMap(pdfShadingMap);
        }
        return pdfShadingMap;
    }

    public void removeShadingMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Shading);
    }

    public PDFShading getShading(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFShadingMap shadingMap = this.getShadingMap();
        if (shadingMap != null) {
            return shadingMap.get(name);
        }
        return null;
    }

    public PDFXObjectMap getXObjectMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_XObject));
    }

    public void setXObjectMap(PDFXObjectMap map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_XObject, map);
    }

    public PDFXObjectMap procureXObjectMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap pdfXObjectMap = this.getXObjectMap();
        if (pdfXObjectMap == null) {
            pdfXObjectMap = PDFXObjectMap.newInstance(this.getPDFDocument());
            this.setXObjectMap(pdfXObjectMap);
        }
        return pdfXObjectMap;
    }

    public void removeXObjectMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_XObject);
    }

    public PDFXObject getXObject(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap xobjectMap = this.getXObjectMap();
        if (xobjectMap != null) {
            return xobjectMap.get(name);
        }
        return null;
    }

    public PDFExtGStateMap getExtGStateMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFExtGStateMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_ExtGState));
    }

    public void setExtGStateMap(PDFExtGStateMap map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ExtGState, map);
    }

    public PDFExtGStateMap procureExtGStateMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFExtGStateMap pdfExtGStateMap = this.getExtGStateMap();
        if (pdfExtGStateMap == null) {
            pdfExtGStateMap = PDFExtGStateMap.newInstance(this.getPDFDocument());
            this.setExtGStateMap(pdfExtGStateMap);
        }
        return pdfExtGStateMap;
    }

    public void removeExtGStateMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_ExtGState);
    }

    public PDFExtGState getExtGState(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFExtGStateMap extGStateMap = this.getExtGStateMap();
        if (extGStateMap != null) {
            return (PDFExtGState)extGStateMap.get(name);
        }
        return null;
    }

    public PDFFontMap getFontMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFontMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_Font));
    }

    public void setFontMap(PDFFontMap map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Font, map);
    }

    public PDFFontMap procureFontMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontMap pdfFontMap = this.getFontMap();
        if (pdfFontMap == null) {
            pdfFontMap = PDFFontMap.newInstance(this.getPDFDocument());
            this.setFontMap(pdfFontMap);
        }
        return pdfFontMap;
    }

    public void removeFontMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Font);
    }

    public PDFFont getFont(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontMap fontMap = this.getFontMap();
        if (fontMap != null) {
            return fontMap.get(name);
        }
        return null;
    }

    public PDFMCPropertyMap getMCPropertyMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMCPropertyMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_Properties));
    }

    public void setMCPropertyMap(PDFMCPropertyMap properties) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Properties, properties);
    }

    public PDFMCPropertyMap procureMCPropertyMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMCPropertyMap pdfMCPropertyMap = this.getMCPropertyMap();
        if (pdfMCPropertyMap == null) {
            pdfMCPropertyMap = PDFMCPropertyMap.newInstance(this.getPDFDocument());
            this.setMCPropertyMap(pdfMCPropertyMap);
        }
        return pdfMCPropertyMap;
    }

    public void removeMCPropertyMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Properties);
    }

    public PDFMCProperty getMCProperty(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMCPropertyMap mcPropertyMap = this.getMCPropertyMap();
        if (mcPropertyMap != null) {
            return mcPropertyMap.get(name);
        }
        return null;
    }

    public ASName[] getProcSetList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName[] names = null;
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_ProcSet);
        if (cosArray != null) {
            int count = cosArray.size();
            names = new ASName[count];
            for (int i = 0; i < count; ++i) {
                names[i] = cosArray.getName(i);
            }
        }
        return names;
    }

    public void setProcSetList(ASName[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (names != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < names.length; ++i) {
                cosArray.addName(names[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_ProcSet, cosArray);
    }
}

